/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.serialization;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.serialization.EncryptingSerializer;
import org.junit.Assert;

public class EncryptingSerializerUnitTest
extends TestCase {
    private EncryptingSerializer serializer;

    protected void setUp() throws Exception {
        this.serializer = new EncryptingSerializer();
        this.serializer.setPreSharedKey("my_secret_key");
    }

    public void testDeserialize_NullInput() throws IOException, ClassNotFoundException {
        Object result = this.serializer.deSerialize(null, null);
        EncryptingSerializerUnitTest.assertNull((String)"Should have nothing.", (Object)result);
    }

    public void testSimpleBackAndForth() throws Exception {
        String before = "adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231";
        String after = (String)this.serializer.deSerialize(this.serializer.serialize((Object)"adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231"), null);
        EncryptingSerializerUnitTest.assertEquals((String)"Before and after should be the same.", (String)"adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231", (String)after);
    }

    public void testGCMBackAndForth() throws Exception {
        this.serializer.setAesCipherTransformation("AES/GCM/NoPadding");
        String before = "adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231";
        String after = (String)this.serializer.deSerialize(this.serializer.serialize((Object)"adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231"), null);
        EncryptingSerializerUnitTest.assertEquals((String)"Before and after should be the same.", (String)"adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231", (String)after);
    }

    public void testDifferentKey() throws Exception {
        String before = "adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231";
        byte[] serialized = this.serializer.serialize((Object)"adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231");
        this.serializer.setPreSharedKey("another_key");
        Assert.assertThrows(IOException.class, () -> this.serializer.deSerialize(serialized, null));
    }

    public void testSerialize_NullInput() throws Exception {
        Object before = null;
        byte[] serialized = this.serializer.serialize(before);
        String after = (String)this.serializer.deSerialize(serialized, null);
        EncryptingSerializerUnitTest.assertNull((String)("Should have nothing. after =" + after), (Object)after);
    }
}

