/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator.jwt;

import java.security.KeyStore;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.realm.JWTRealmCodec;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.sts.token.validator.jwt.JWTRoleParser;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.w3c.dom.Element;

public class JWTTokenValidator
implements TokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(JWTTokenValidator.class);
    private int clockOffset;
    private int ttl;
    private JWTRoleParser roleParser;
    private JWTRealmCodec realmCodec;

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        Element tokenEl;
        Object token = validateTarget.getToken();
        if (token instanceof Element && (tokenEl = (Element)token).getFirstChild().getNodeType() == 3) {
            try {
                JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(tokenEl.getTextContent());
                if (jwtConsumer.getJwtToken() != null) {
                    return true;
                }
            }
            catch (RuntimeException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating JWT Token");
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        TokenValidatorResponse response = new TokenValidatorResponse();
        ReceivedToken validateTarget = tokenParameters.getToken();
        validateTarget.setState(ReceivedToken.STATE.INVALID);
        response.setToken(validateTarget);
        String token = ((Element)validateTarget.getToken()).getTextContent();
        if (token == null || "".equals(token)) {
            return response;
        }
        if (token.split("\\.").length != 3) {
            LOG.log(Level.WARNING, "JWT Token appears not to be signed. Validation has failed");
            return response;
        }
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(token);
        JwtToken jwt = jwtConsumer.getJwtToken();
        Properties verificationProperties = new Properties();
        Crypto signatureCrypto = stsProperties.getSignatureCrypto();
        String alias = stsProperties.getSignatureUsername();
        if (alias != null) {
            verificationProperties.put("rs.security.keystore.alias", alias);
        }
        if (!(signatureCrypto instanceof Merlin)) {
            throw new STSException("Can't get the keystore", STSException.REQUEST_FAILED);
        }
        KeyStore keystore = ((Merlin)signatureCrypto).getKeyStore();
        verificationProperties.put("rs.security.keystore", keystore);
        JwsSignatureVerifier signatureVerifier = JwsUtils.loadSignatureVerifier((Properties)verificationProperties, (JwsHeaders)jwt.getJwsHeaders());
        if (!jwtConsumer.verifySignatureWith(signatureVerifier)) {
            return response;
        }
        try {
            this.validateToken(jwt);
        }
        catch (RuntimeException ex) {
            LOG.log(Level.WARNING, "JWT token validation failed", ex);
            return response;
        }
        if (this.realmCodec != null) {
            String tokenRealm = this.realmCodec.getRealmFromToken(jwt);
            response.setTokenRealm(tokenRealm);
        }
        if (this.isVerifiedWithAPublicKey(jwt)) {
            SimplePrincipal principal = new SimplePrincipal(jwt.getClaims().getSubject());
            response.setPrincipal((Principal)principal);
            if (this.roleParser != null) {
                Set<Principal> roles = this.roleParser.parseRolesFromToken((Principal)principal, null, jwt);
                response.setRoles(roles);
            }
        }
        validateTarget.setState(ReceivedToken.STATE.VALID);
        LOG.fine("JWT Token successfully validated");
        return response;
    }

    private boolean isVerifiedWithAPublicKey(JwtToken jwt) {
        String alg = (String)jwt.getJwsHeader("alg");
        SignatureAlgorithm sigAlg = SignatureAlgorithm.getAlgorithm((String)alg);
        return SignatureAlgorithm.isPublicKeyAlgorithm((SignatureAlgorithm)sigAlg);
    }

    protected void validateToken(JwtToken jwt) {
        JwtUtils.validateTokenClaims((JwtClaims)jwt.getClaims(), (int)this.ttl, (int)this.clockOffset, (boolean)false);
    }

    public int getClockOffset() {
        return this.clockOffset;
    }

    public void setClockOffset(int clockOffset) {
        this.clockOffset = clockOffset;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public JWTRoleParser getRoleParser() {
        return this.roleParser;
    }

    public void setRoleParser(JWTRoleParser roleParser) {
        this.roleParser = roleParser;
    }

    public JWTRealmCodec getRealmCodec() {
        return this.realmCodec;
    }

    public void setRealmCodec(JWTRealmCodec realmCodec) {
        this.realmCodec = realmCodec;
    }
}

