/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.osgi;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.Feature;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static final String CONFIG_PID = "org.apache.cxf.features.logging";

    public void start(BundleContext bundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", CONFIG_PID);
        bundleContext.registerService(ManagedService.class.getName(), (Object)new ConfigUpdater(bundleContext), properties);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private static final class ConfigUpdater
    implements ManagedService {
        private BundleContext bundleContext;
        private ServiceRegistration<?> serviceReg;
        private ServiceRegistration<?> intentReg;
        private LoggingFeature logging = new LoggingFeature();

        ConfigUpdater(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        public void updated(Dictionary config) throws ConfigurationException {
            Hashtable<String, String> properties;
            boolean enabled = Boolean.valueOf(this.getValue(config, "enabled", "false"));
            LOG.info("CXF message logging feature " + (enabled ? "enabled" : "disabled"));
            Integer limit = Integer.valueOf(this.getValue(config, "limit", "65536"));
            Boolean pretty = Boolean.valueOf(this.getValue(config, "pretty", "false"));
            Boolean verbose = Boolean.valueOf(this.getValue(config, "verbose", "true"));
            Long inMemThreshold = Long.valueOf(this.getValue(config, "inMemThresHold", "-1"));
            Boolean logMultipart = Boolean.valueOf(this.getValue(config, "logMultipart", "true"));
            Boolean logBinary = Boolean.valueOf(this.getValue(config, "logBinary", "false"));
            Set<String> sensitiveElementNames = this.getTrimmedSet(config, "sensitiveElementNames");
            Set<String> sensitiveProtocolHeaderNames = this.getTrimmedSet(config, "sensitiveProtocolHeaderNames");
            if (limit != null) {
                this.logging.setLimit(limit);
            }
            if (inMemThreshold != null) {
                this.logging.setInMemThreshold(inMemThreshold);
            }
            if (pretty != null) {
                this.logging.setPrettyLogging(pretty);
            }
            if (verbose != null) {
                this.logging.setVerbose(verbose);
            }
            if (logMultipart != null) {
                this.logging.setLogMultipart(logMultipart);
            }
            if (logBinary != null) {
                this.logging.setLogBinary(logBinary);
            }
            this.logging.setSensitiveElementNames(sensitiveElementNames);
            this.logging.setSensitiveProtocolHeaderNames(sensitiveProtocolHeaderNames);
            if (this.intentReg == null) {
                properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("org.apache.cxf.dosgi.IntentName", "logging");
                this.bundleContext.registerService(AbstractFeature.class.getName(), (Object)this.logging, properties);
            }
            if (enabled) {
                if (this.serviceReg == null) {
                    properties = new Hashtable();
                    ((Dictionary)properties).put("name", "logging");
                    this.serviceReg = this.bundleContext.registerService(Feature.class.getName(), (Object)this.logging, properties);
                }
            } else if (this.serviceReg != null) {
                this.serviceReg.unregister();
                this.serviceReg = null;
            }
        }

        private Set<String> getTrimmedSet(Dictionary config, String propertyKey) {
            return new HashSet<String>(Arrays.stream(String.valueOf(this.getValue(config, propertyKey, "")).split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.toSet()));
        }

        private String getValue(Dictionary config, String key, String defaultValue) {
            if (config == null) {
                return defaultValue;
            }
            String value = (String)config.get(key);
            return value != null ? value : defaultValue;
        }
    }
}

