/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.QueueField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.QueueFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class QueueView
extends ActiveMQAbstractView<QueueControl> {
    private static final String defaultSortColumn = QueueField.NAME.getName();
    private ActiveMQServer server;

    public QueueView(ActiveMQServer server) {
        this.predicate = new QueueFilterPredicate(server);
        this.server = server;
    }

    @Override
    public Class getClassT() {
        return QueueControl.class;
    }

    @Override
    public JsonObjectBuilder toJson(QueueControl queue) {
        Queue q = this.server.locateQueue(new SimpleString(queue.getName()));
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(QueueField.ID.getName(), this.toString(queue.getID())).add(QueueField.NAME.getName(), this.toString(queue.getName())).add(QueueField.ADDRESS.getName(), this.toString(queue.getAddress())).add(QueueField.FILTER.getName(), this.toString(queue.getFilter())).add(QueueField.DURABLE.getName(), this.toString(queue.isDurable())).add(QueueField.PAUSED.getName(), this.toString(q.isPaused())).add(QueueField.TEMPORARY.getName(), this.toString(queue.isTemporary())).add(QueueField.PURGE_ON_NO_CONSUMERS.getName(), this.toString(queue.isPurgeOnNoConsumers())).add(QueueField.CONSUMER_COUNT.getName(), this.toString(queue.getConsumerCount())).add(QueueField.MAX_CONSUMERS.getName(), this.toString(queue.getMaxConsumers())).add(QueueField.AUTO_CREATED.getName(), this.toString(q.isAutoCreated())).add(QueueField.USER.getName(), this.toString(q.getUser())).add(QueueField.ROUTING_TYPE.getName(), this.toString(queue.getRoutingType())).add(QueueField.MESSAGES_ADDED.getName(), this.toString(queue.getMessagesAdded())).add(QueueField.MESSAGE_COUNT.getName(), this.toString(queue.getMessageCount())).add(QueueField.MESSAGES_ACKED.getName(), this.toString(queue.getMessagesAcknowledged())).add(QueueField.MESSAGES_EXPIRED.getName(), this.toString(queue.getMessagesExpired())).add(QueueField.DELIVERING_COUNT.getName(), this.toString(queue.getDeliveringCount())).add(QueueField.MESSAGES_KILLED.getName(), this.toString(queue.getMessagesKilled())).add(QueueField.DIRECT_DELIVER.getName(), this.toString(q.isDirectDeliver())).add(QueueField.EXCLUSIVE.getName(), this.toString(queue.isExclusive())).add(QueueField.LAST_VALUE.getName(), this.toString(queue.isLastValue())).add(QueueField.LAST_VALUE_KEY.getName(), this.toString(queue.getLastValueKey())).add(QueueField.SCHEDULED_COUNT.getName(), this.toString(queue.getScheduledCount())).add(QueueField.GROUP_REBALANCE.getName(), this.toString(queue.isGroupRebalance())).add(QueueField.GROUP_REBALANCE_PAUSE_DISPATCH.getName(), this.toString(queue.isGroupRebalancePauseDispatch())).add(QueueField.GROUP_BUCKETS.getName(), this.toString(queue.getGroupBuckets())).add(QueueField.GROUP_FIRST_KEY.getName(), this.toString(queue.getGroupFirstKey())).add(QueueField.ENABLED.getName(), this.toString(queue.isEnabled())).add(QueueField.RING_SIZE.getName(), this.toString(queue.getRingSize())).add(QueueField.CONSUMERS_BEFORE_DISPATCH.getName(), this.toString(queue.getConsumersBeforeDispatch())).add(QueueField.DELAY_BEFORE_DISPATCH.getName(), this.toString(queue.getDelayBeforeDispatch())).add(QueueField.AUTO_DELETE.getName(), this.toString(q.isAutoDelete()));
        return obj;
    }

    @Override
    public Object getField(QueueControl queue, String fieldName) {
        Queue q = this.server.locateQueue(new SimpleString(queue.getName()));
        QueueField field = QueueField.valueOfName(fieldName);
        switch (field) {
            case ID: {
                return queue.getID();
            }
            case NAME: {
                return queue.getName();
            }
            case ADDRESS: {
                return queue.getAddress();
            }
            case FILTER: {
                return queue.getFilter();
            }
            case DURABLE: {
                return queue.isDurable();
            }
            case PAUSED: {
                return q.isPaused();
            }
            case TEMPORARY: {
                return queue.isTemporary();
            }
            case PURGE_ON_NO_CONSUMERS: {
                return queue.isPurgeOnNoConsumers();
            }
            case CONSUMER_COUNT: {
                return queue.getConsumerCount();
            }
            case MAX_CONSUMERS: {
                return queue.getMaxConsumers();
            }
            case AUTO_CREATED: {
                return q.isAutoCreated();
            }
            case USER: {
                return q.getUser();
            }
            case ROUTING_TYPE: {
                return queue.getRoutingType();
            }
            case MESSAGES_ADDED: {
                return queue.getMessagesAdded();
            }
            case MESSAGE_COUNT: {
                return queue.getMessageCount();
            }
            case MESSAGES_ACKED: {
                return queue.getMessagesAcknowledged();
            }
            case MESSAGES_EXPIRED: {
                return queue.getMessagesExpired();
            }
            case DELIVERING_COUNT: {
                return queue.getDeliveringCount();
            }
            case MESSAGES_KILLED: {
                return queue.getMessagesKilled();
            }
            case DIRECT_DELIVER: {
                return q.isDirectDeliver();
            }
            case EXCLUSIVE: {
                return q.isExclusive();
            }
            case LAST_VALUE: {
                return q.isLastValue();
            }
            case LAST_VALUE_KEY: {
                return q.getLastValueKey();
            }
            case SCHEDULED_COUNT: {
                return q.getScheduledCount();
            }
            case GROUP_REBALANCE: {
                return queue.isGroupRebalance();
            }
            case GROUP_REBALANCE_PAUSE_DISPATCH: {
                return queue.isGroupRebalancePauseDispatch();
            }
            case GROUP_BUCKETS: {
                return queue.getGroupBuckets();
            }
            case GROUP_FIRST_KEY: {
                return queue.getGroupFirstKey();
            }
            case ENABLED: {
                return q.isEnabled();
            }
            case RING_SIZE: {
                return q.getRingSize();
            }
            case CONSUMERS_BEFORE_DISPATCH: {
                return q.getConsumersBeforeDispatch();
            }
            case DELAY_BEFORE_DISPATCH: {
                return q.getDelayBeforeDispatch();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

