/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderColumn;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;

@Entity
public class Client
implements Serializable {
    private static final long serialVersionUID = -5550840247125850922L;
    private String clientId;
    private String clientSecret;
    private String clientIpAddress;
    private String applicationName;
    private String applicationDescription;
    private String applicationWebUri;
    private String applicationLogoUri;
    private String applicationLogoutUri;
    private List<String> applicationCertificates = new LinkedList<String>();
    private List<String> redirectUris = new LinkedList<String>();
    private boolean isConfidential;
    private List<String> allowedGrantTypes = new LinkedList<String>();
    private List<String> registeredScopes = new LinkedList<String>();
    private List<String> registeredAudiences = new LinkedList<String>();
    private Map<String, String> properties = new HashMap<String, String>();
    private UserSubject subject;
    private UserSubject resourceOwnerSubject;
    private long registeredAt;
    private String homeRealm;
    private boolean registeredDynamically;
    private String tokenEndpointAuthMethod;

    public Client() {
    }

    public Client(String clientId, String clientSecret, boolean isConfidential) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.isConfidential = isConfidential;
    }

    public Client(String clientId, String clientSecret, boolean isConfidential, String applicationName) {
        this(clientId, clientSecret, isConfidential);
        this.applicationName = applicationName;
    }

    public Client(String clientId, String clientSecret, boolean isConfidential, String applicationName, String applicationWebUri) {
        this(clientId, clientSecret, isConfidential, applicationName);
        this.applicationWebUri = applicationWebUri;
    }

    @Id
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String id) {
        this.clientId = id;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String id) {
        this.clientSecret = id;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationWebUri() {
        return this.applicationWebUri;
    }

    public void setApplicationWebUri(String applicationWebUri) {
        this.applicationWebUri = applicationWebUri;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public void setApplicationDescription(String applicationDescription) {
        this.applicationDescription = applicationDescription;
    }

    public String getApplicationLogoUri() {
        return this.applicationLogoUri;
    }

    public void setApplicationLogoUri(String logoPath) {
        this.applicationLogoUri = logoPath;
    }

    public boolean isConfidential() {
        return this.isConfidential;
    }

    public void setConfidential(boolean isConf) {
        this.isConfidential = isConf;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris != null ? redirectUris : Collections.emptyList();
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getAllowedGrantTypes() {
        return this.allowedGrantTypes;
    }

    public void setAllowedGrantTypes(List<String> allowedGrantTypes) {
        this.allowedGrantTypes = allowedGrantTypes != null ? allowedGrantTypes : Collections.emptyList();
    }

    @OneToOne
    public UserSubject getSubject() {
        return this.subject;
    }

    public void setSubject(UserSubject subject) {
        this.subject = subject;
    }

    @ManyToOne
    public UserSubject getResourceOwnerSubject() {
        return this.resourceOwnerSubject;
    }

    public void setResourceOwnerSubject(UserSubject resourceOwnerSubject) {
        this.resourceOwnerSubject = resourceOwnerSubject;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="name")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getRegisteredScopes() {
        return this.registeredScopes;
    }

    public void setRegisteredScopes(List<String> registeredScopes) {
        this.registeredScopes = registeredScopes != null ? registeredScopes : Collections.emptyList();
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getRegisteredAudiences() {
        return this.registeredAudiences;
    }

    public void setRegisteredAudiences(List<String> registeredAudiences) {
        this.registeredAudiences = registeredAudiences != null ? registeredAudiences : Collections.emptyList();
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    @Lob
    public List<String> getApplicationCertificates() {
        return this.applicationCertificates;
    }

    public void setApplicationCertificates(List<String> applicationCertificates) {
        this.applicationCertificates = applicationCertificates != null ? applicationCertificates : Collections.emptyList();
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public long getRegisteredAt() {
        return this.registeredAt;
    }

    public void setRegisteredAt(long registeredAt) {
        this.registeredAt = registeredAt;
    }

    public String getHomeRealm() {
        return this.homeRealm;
    }

    public void setHomeRealm(String homeRealm) {
        this.homeRealm = homeRealm;
    }

    public boolean isRegisteredDynamically() {
        return this.registeredDynamically;
    }

    public void setRegisteredDynamically(boolean registeredDynamically) {
        this.registeredDynamically = registeredDynamically;
    }

    public String getApplicationLogoutUri() {
        return this.applicationLogoutUri;
    }

    public void setApplicationLogoutUri(String applicationLogoutUri) {
        this.applicationLogoutUri = applicationLogoutUri;
    }

    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }
}

