/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.util.UUID;

public class SiteMaster
extends SiteUUID {
    protected static final SiteMaster ALL_SMS = new SiteMaster(null);
    protected static final int HASH = ALL_SMS.hashCode();

    public SiteMaster() {
    }

    public SiteMaster(String site) {
        super(0L, 0L, null, site);
    }

    @Override
    public Supplier<? extends UUID> create() {
        return SiteMaster::new;
    }

    @Override
    public SiteAddress.Type type() {
        return this.site == null ? SiteAddress.Type.SM_ALL : SiteAddress.Type.SM;
    }

    @Override
    public int compareTo(Address other) {
        if (other instanceof SiteMaster) {
            SiteMaster tmp = (SiteMaster)other;
            String other_site = tmp.getSite();
            if (this.site == null) {
                if (other_site == null) {
                    return 0;
                }
                return -1;
            }
            if (other_site == null) {
                return 1;
            }
            int rc = this.site.compareTo(other_site);
            return rc == 0 ? super.compareTo(other) : rc;
        }
        return super.compareTo(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SiteMaster)) {
            return false;
        }
        return this.compareTo((Address)obj) == 0;
    }

    @Override
    public int hashCode() {
        return this.site == null ? HASH : super.hashCode();
    }

    @Override
    public UUID copy() {
        return new SiteMaster(this.site);
    }

    @Override
    public String toString() {
        return String.format("SiteMaster(%s)", this.site != null ? this.site : "<all sites>");
    }
}

