/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.interceptor;

import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;

public class SCTOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    static final Logger LOG = LogUtils.getL7dLogger(SCTOutInterceptor.class);

    public SCTOutInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AddressingProperties inProps = (AddressingProperties)message.getContextualProperty("jakarta.xml.ws.addressing.context.inbound");
        AddressingProperties outProps = (AddressingProperties)message.getContextualProperty("jakarta.xml.ws.addressing.context.outbound");
        if (inProps != null) {
            if (outProps == null) {
                outProps = new AddressingProperties(inProps.getNamespaceURI());
            }
            AttributedURIType action = new AttributedURIType();
            action.setValue(inProps.getAction().getValue().replace("/RST/", "/RSTR/"));
            outProps.setAction(action);
            message.put("jakarta.xml.ws.addressing.context.outbound", (Object)outProps);
        }
    }
}

