/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;

public class ClusterTopologyChangeMessage_V2
extends ClusterTopologyChangeMessage {
    protected long uniqueEventID;
    protected String backupGroupName;

    public ClusterTopologyChangeMessage_V2(long uniqueEventID, String nodeID, String backupGroupName, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        super((byte)114);
        this.nodeID = nodeID;
        this.pair = pair;
        this.last = last;
        this.exit = false;
        this.uniqueEventID = uniqueEventID;
        this.backupGroupName = backupGroupName;
    }

    public ClusterTopologyChangeMessage_V2(long uniqueEventID, String nodeID) {
        super((byte)114);
        this.exit = true;
        this.nodeID = nodeID;
        this.uniqueEventID = uniqueEventID;
    }

    public ClusterTopologyChangeMessage_V2() {
        super((byte)114);
    }

    public ClusterTopologyChangeMessage_V2(byte clusterTopologyV3) {
        super(clusterTopologyV3);
    }

    public long getUniqueEventID() {
        return this.uniqueEventID;
    }

    public String getBackupGroupName() {
        return this.backupGroupName;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.exit);
        buffer.writeString(this.nodeID);
        buffer.writeLong(this.uniqueEventID);
        if (!this.exit) {
            if (this.pair.getA() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getA()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            if (this.pair.getB() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getB()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(this.last);
        }
        buffer.writeNullableString(this.backupGroupName);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.exit = buffer.readBoolean();
        this.nodeID = buffer.readString();
        this.uniqueEventID = buffer.readLong();
        if (!this.exit) {
            TransportConfiguration b;
            TransportConfiguration a;
            boolean hasPrimary = buffer.readBoolean();
            if (hasPrimary) {
                a = new TransportConfiguration();
                a.decode(buffer);
            } else {
                a = null;
            }
            boolean hasBackup = buffer.readBoolean();
            if (hasBackup) {
                b = new TransportConfiguration();
                b.decode(buffer);
            } else {
                b = null;
            }
            this.pair = new Pair((Object)a, (Object)b);
            this.last = buffer.readBoolean();
        }
        if (buffer.readableBytes() > 0) {
            this.backupGroupName = buffer.readNullableString();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.backupGroupName == null ? 0 : this.backupGroupName.hashCode());
        result = 31 * result + (int)(this.uniqueEventID ^ this.uniqueEventID >>> 32);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", exit=" + this.exit);
        buff.append(", last=" + this.last);
        buff.append(", nodeID=" + this.nodeID);
        buff.append(", pair=" + this.pair);
        buff.append(", backupGroupName=" + this.backupGroupName);
        buff.append(", uniqueEventID=" + this.uniqueEventID);
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClusterTopologyChangeMessage_V2)) {
            return false;
        }
        ClusterTopologyChangeMessage_V2 other = (ClusterTopologyChangeMessage_V2)obj;
        if (this.uniqueEventID != other.uniqueEventID) {
            return false;
        }
        return !(this.backupGroupName == null ? other.backupGroupName != null : !this.backupGroupName.equals(other.backupGroupName));
    }
}

