/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.QueueStatusEncoding;

public class PersistentQueueBindingEncoding
implements EncodingSupport,
QueueBindingInfo {
    private long id;
    private SimpleString name;
    private SimpleString address;
    private SimpleString filterString;
    private boolean autoCreated;
    private SimpleString user;
    private List<QueueStatusEncoding> queueStatusEncodings;
    private int maxConsumers;
    private boolean purgeOnNoConsumers;
    private boolean enabled;
    private boolean exclusive;
    private boolean lastValue;
    private SimpleString lastValueKey;
    private boolean nonDestructive;
    private int consumersBeforeDispatch;
    private long delayBeforeDispatch;
    private byte routingType;
    private boolean configurationManaged;
    private boolean groupRebalance;
    private boolean groupRebalancePauseDispatch;
    private int groupBuckets;
    private SimpleString groupFirstKey;
    private boolean autoDelete;
    private long autoDeleteDelay;
    private long autoDeleteMessageCount;
    private long ringSize;
    private boolean internal;

    public PersistentQueueBindingEncoding() {
    }

    public String toString() {
        return "PersistentQueueBindingEncoding [id=" + this.id + ", name=" + this.name + ", address=" + this.address + ", filterString=" + this.filterString + ", user=" + this.user + ", autoCreated=" + this.autoCreated + ", maxConsumers=" + this.maxConsumers + ", purgeOnNoConsumers=" + this.purgeOnNoConsumers + ", enabled=" + this.enabled + ", exclusive=" + this.exclusive + ", lastValue=" + this.lastValue + ", lastValueKey=" + this.lastValueKey + ", nonDestructive=" + this.nonDestructive + ", consumersBeforeDispatch=" + this.consumersBeforeDispatch + ", delayBeforeDispatch=" + this.delayBeforeDispatch + ", routingType=" + this.routingType + ", configurationManaged=" + this.configurationManaged + ", groupRebalance=" + this.groupRebalance + ", groupRebalancePauseDispatch=" + this.groupRebalancePauseDispatch + ", groupBuckets=" + this.groupBuckets + ", groupFirstKey=" + this.groupFirstKey + ", autoDelete=" + this.autoDelete + ", autoDeleteDelay=" + this.autoDeleteDelay + ", autoDeleteMessageCount=" + this.autoDeleteMessageCount + ", internal=" + this.internal + "]";
    }

    public PersistentQueueBindingEncoding(SimpleString name, SimpleString address, SimpleString filterString, SimpleString user, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean enabled, boolean exclusive, boolean groupRebalance, boolean groupRebalancePauseDispatch, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, byte routingType, boolean configurationManaged, long ringSize, boolean internal) {
        this.name = name;
        this.address = address;
        this.filterString = filterString;
        this.user = user;
        this.autoCreated = autoCreated;
        this.maxConsumers = maxConsumers;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
        this.enabled = enabled;
        this.exclusive = exclusive;
        this.groupRebalance = groupRebalance;
        this.groupBuckets = groupBuckets;
        this.groupFirstKey = groupFirstKey;
        this.lastValue = lastValue;
        this.lastValueKey = lastValueKey;
        this.nonDestructive = nonDestructive;
        this.consumersBeforeDispatch = consumersBeforeDispatch;
        this.delayBeforeDispatch = delayBeforeDispatch;
        this.autoDelete = autoDelete;
        this.autoDeleteDelay = autoDeleteDelay;
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        this.routingType = routingType;
        this.configurationManaged = configurationManaged;
        this.ringSize = ringSize;
        this.internal = internal;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void replaceQueueName(SimpleString newName) {
        this.name = newName;
    }

    @Override
    public SimpleString getFilterString() {
        return this.filterString;
    }

    @Override
    public SimpleString getQueueName() {
        return this.name;
    }

    @Override
    public SimpleString getUser() {
        return this.user;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public boolean isConfigurationManaged() {
        return this.configurationManaged;
    }

    @Override
    public void setConfigurationManaged(boolean configurationManaged) {
        this.configurationManaged = configurationManaged;
    }

    @Override
    public void addQueueStatusEncoding(QueueStatusEncoding status) {
        if (this.queueStatusEncodings == null) {
            this.queueStatusEncodings = new LinkedList<QueueStatusEncoding>();
        }
        this.queueStatusEncodings.add(status);
    }

    @Override
    public List<QueueStatusEncoding> getQueueStatusEncodings() {
        return this.queueStatusEncodings;
    }

    @Override
    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    @Override
    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    @Override
    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    @Override
    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    @Override
    public boolean isLastValue() {
        return this.lastValue;
    }

    @Override
    public void setLastValue(boolean lastValue) {
        this.lastValue = lastValue;
    }

    @Override
    public SimpleString getLastValueKey() {
        return this.lastValueKey;
    }

    @Override
    public void setLastValueKey(SimpleString lastValueKey) {
        this.lastValueKey = lastValueKey;
    }

    @Override
    public boolean isNonDestructive() {
        return this.nonDestructive;
    }

    @Override
    public void setNonDestructive(boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
    }

    @Override
    public int getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    @Override
    public void setConsumersBeforeDispatch(int consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
    }

    @Override
    public long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    @Override
    public void setDelayBeforeDispatch(long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
    }

    @Override
    public byte getRoutingType() {
        return this.routingType;
    }

    @Override
    public void setRoutingType(byte routingType) {
        this.routingType = routingType;
    }

    @Override
    public boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    @Override
    public boolean isGroupRebalancePauseDispatch() {
        return this.groupRebalancePauseDispatch;
    }

    @Override
    public int getGroupBuckets() {
        return this.groupBuckets;
    }

    @Override
    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    @Override
    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    @Override
    public long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    @Override
    public long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    @Override
    public long getRingSize() {
        return this.ringSize;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readSimpleString();
        this.address = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        String metadata = buffer.readNullableSimpleString().toString();
        if (metadata != null) {
            String[] elements;
            for (String element : elements = metadata.split(";")) {
                String[] keyValuePair = element.split("=");
                if (keyValuePair.length != 2 || !keyValuePair[0].equals("user")) continue;
                this.user = SimpleString.of((String)keyValuePair[1]);
            }
        }
        this.autoCreated = buffer.readBoolean();
        if (buffer.readableBytes() > 0) {
            this.maxConsumers = buffer.readInt();
            this.purgeOnNoConsumers = buffer.readBoolean();
            this.routingType = buffer.readByte();
        } else {
            this.maxConsumers = ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers();
            this.purgeOnNoConsumers = ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers();
            this.routingType = ActiveMQDefaultConfiguration.getDefaultRoutingType().getType();
        }
        this.exclusive = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultExclusive();
        this.lastValue = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultLastValue();
        this.configurationManaged = buffer.readableBytes() > 0 ? buffer.readBoolean() : false;
        this.consumersBeforeDispatch = buffer.readableBytes() > 0 ? buffer.readInt() : ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch();
        this.delayBeforeDispatch = buffer.readableBytes() > 0 ? buffer.readLong() : ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch();
        this.lastValueKey = buffer.readableBytes() > 0 ? buffer.readNullableSimpleString() : ActiveMQDefaultConfiguration.getDefaultLastValueKey();
        this.nonDestructive = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultNonDestructive();
        this.groupRebalance = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultGroupRebalance();
        this.groupBuckets = buffer.readableBytes() > 0 ? buffer.readInt() : ActiveMQDefaultConfiguration.getDefaultGroupBuckets();
        this.autoDelete = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultQueueAutoDelete((boolean)this.autoCreated);
        this.autoDeleteDelay = buffer.readableBytes() > 0 ? buffer.readLong() : ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteDelay();
        this.autoDeleteMessageCount = buffer.readableBytes() > 0 ? buffer.readLong() : ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteMessageCount();
        this.groupFirstKey = buffer.readableBytes() > 0 ? buffer.readNullableSimpleString() : ActiveMQDefaultConfiguration.getDefaultGroupFirstKey();
        this.ringSize = buffer.readableBytes() > 0 ? buffer.readLong() : ActiveMQDefaultConfiguration.getDefaultRingSize();
        this.enabled = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultEnabled();
        this.groupRebalancePauseDispatch = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultGroupRebalancePauseDispatch();
        this.internal = buffer.readableBytes() > 0 ? buffer.readBoolean() : ActiveMQDefaultConfiguration.getDefaultInternal();
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.name);
        buffer.writeSimpleString(this.address);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeNullableSimpleString(this.createMetadata());
        buffer.writeBoolean(this.autoCreated);
        buffer.writeInt(this.maxConsumers);
        buffer.writeBoolean(this.purgeOnNoConsumers);
        buffer.writeByte(this.routingType);
        buffer.writeBoolean(this.exclusive);
        buffer.writeBoolean(this.lastValue);
        buffer.writeBoolean(this.configurationManaged);
        buffer.writeInt(this.consumersBeforeDispatch);
        buffer.writeLong(this.delayBeforeDispatch);
        buffer.writeNullableSimpleString(this.lastValueKey);
        buffer.writeBoolean(this.nonDestructive);
        buffer.writeBoolean(this.groupRebalance);
        buffer.writeInt(this.groupBuckets);
        buffer.writeBoolean(this.autoDelete);
        buffer.writeLong(this.autoDeleteDelay);
        buffer.writeLong(this.autoDeleteMessageCount);
        buffer.writeNullableSimpleString(this.groupFirstKey);
        buffer.writeLong(this.ringSize);
        buffer.writeBoolean(this.enabled);
        buffer.writeBoolean(this.groupRebalancePauseDispatch);
        buffer.writeBoolean(this.internal);
    }

    public int getEncodeSize() {
        return SimpleString.sizeofString((SimpleString)this.name) + SimpleString.sizeofString((SimpleString)this.address) + SimpleString.sizeofNullableString((SimpleString)this.filterString) + 1 + SimpleString.sizeofNullableString((SimpleString)this.createMetadata()) + 4 + 1 + 1 + 1 + 1 + 1 + 4 + 8 + SimpleString.sizeofNullableString((SimpleString)this.lastValueKey) + 1 + 1 + 4 + 1 + 8 + 8 + SimpleString.sizeofNullableString((SimpleString)this.groupFirstKey) + 8 + 1 + 1 + 1;
    }

    private SimpleString createMetadata() {
        StringBuilder metadata = new StringBuilder();
        if (this.user != null) {
            metadata.append("user=").append((CharSequence)this.user).append(";");
        }
        return SimpleString.of((String)metadata.toString());
    }
}

