/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.security.Signature;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public enum Algorithm {
    HMAC_SHA1("HmacSHA1", "hmac-sha1", Mac.class),
    HMAC_SHA224("HmacSHA224", "hmac-sha224", Mac.class),
    HMAC_SHA256("HmacSHA256", "hmac-sha256", Mac.class),
    HMAC_SHA384("HmacSHA384", "hmac-sha384", Mac.class),
    HMAC_SHA512("HmacSHA512", "hmac-sha512", Mac.class),
    RSA_SHA1("SHA1withRSA", "rsa-sha1", Signature.class),
    RSA_SHA256("SHA256withRSA", "rsa-sha256", Signature.class),
    RSA_SHA384("SHA384withRSA", "rsa-sha384", Signature.class),
    RSA_SHA512("SHA512withRSA", "rsa-sha512", Signature.class),
    RSA_SHA3_256("SHA3-256withRSA", "rsa-sha3-256", Signature.class),
    RSA_SHA3_384("SHA3-384withRSA", "rsa-sha3-384", Signature.class),
    RSA_SHA3_512("SHA3-512withRSA", "rsa-sha3-512", Signature.class),
    RSA_PSS("RSASSA-PSS", "rsassa-pss", Signature.class),
    DSA_SHA1("SHA1withDSA", "dsa-sha1", Signature.class),
    DSA_SHA224("SHA224withDSA", "dsa-sha224", Signature.class),
    DSA_SHA256("SHA256withDSA", "dsa-sha256", Signature.class),
    DSA_SHA384("SHA384withDSA", "dsa-sha384", Signature.class),
    DSA_SHA512("SHA512withDSA", "dsa-sha512", Signature.class),
    DSA_SHA3_256("SHA3-256withDSA", "dsa-sha3-256", Signature.class),
    DSA_SHA3_384("SHA3-384withDSA", "dsa-sha3-384", Signature.class),
    DSA_SHA3_512("SHA3-512withDSA", "dsa-sha3-512", Signature.class),
    ECDSA_SHA1("SHA1withECDSA", "ecdsa-sha1", Signature.class),
    ECDSA_SHA256("SHA256withECDSA", "ecdsa-sha256", Signature.class),
    ECDSA_SHA384("SHA384withECDSA", "ecdsa-sha384", Signature.class),
    ECDSA_SHA512("SHA512withECDSA", "ecdsa-sha512", Signature.class),
    ECDSA_SHA3_256("SHA3-256withECDSA", "ecdsa-sha3-256", Signature.class),
    ECDSA_SHA3_384("SHA3-384withECDSA", "ecdsa-sha3-384", Signature.class),
    ECDSA_SHA3_512("SHA3-512withECDSA", "ecdsa-sha3-512", Signature.class),
    ECDSA_SHA256_P1363("SHA256withECDSAinP1363Format", "ecdsa-sha256-p1363", Signature.class),
    ECDSA_SHA384_P1363("SHA384withECDSAinP1363Format", "ecdsa-sha384-p1363", Signature.class),
    ECDSA_SHA512_P1363("SHA512withECDSAinP1363Format", "ecdsa-sha512-p1363", Signature.class);

    private static final Map<String, Algorithm> aliases;
    private final String portableName;
    private final String jvmName;
    private final Class type;

    private Algorithm(String jvmName, String portableName, Class type) {
        this.portableName = portableName;
        this.jvmName = jvmName;
        this.type = type;
    }

    public String getPortableName() {
        return this.portableName;
    }

    public String getJvmName() {
        return this.jvmName;
    }

    public Class getType() {
        return this.type;
    }

    public static String toPortableName(String name) {
        return Algorithm.get(name).getPortableName();
    }

    public static String toJvmName(String name) {
        return Algorithm.get(name).getJvmName();
    }

    public static Algorithm get(String name) {
        Algorithm algorithm = aliases.get(Algorithm.normalize(name));
        if (algorithm != null) {
            return algorithm;
        }
        throw new UnsupportedAlgorithmException(name);
    }

    private static String normalize(String algorithm) {
        return algorithm.replaceAll("[^A-Za-z0-9]+", "").toLowerCase();
    }

    public String toString() {
        return this.getPortableName();
    }

    static {
        aliases = new HashMap<String, Algorithm>();
        for (Algorithm algorithm : Algorithm.values()) {
            aliases.put(Algorithm.normalize(algorithm.getJvmName()), algorithm);
            aliases.put(Algorithm.normalize(algorithm.getPortableName()), algorithm);
        }
    }
}

