/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public abstract class RoleDescriptorImpl
extends AbstractSignableSAMLObject
implements RoleDescriptor {
    private String id;
    private Instant validUntil;
    private Duration cacheDuration;
    private final List<String> supportedProtocols;
    private String errorURL;
    private Extensions extensions;
    private Organization organization;
    private final AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);
    private final XMLObjectChildrenList<ContactPerson> contactPersons;
    private final XMLObjectChildrenList<KeyDescriptor> keyDescriptors;

    protected RoleDescriptorImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.supportedProtocols = new LazyList();
        this.contactPersons = new XMLObjectChildrenList((XMLObject)this);
        this.keyDescriptors = new XMLObjectChildrenList((XMLObject)this);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        return Instant.now().isBefore(this.validUntil);
    }

    public Instant getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Instant dt) {
        this.validUntil = (Instant)this.prepareForAssignment(this.validUntil, dt);
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Duration duration) {
        this.cacheDuration = (Duration)this.prepareForAssignment(this.cacheDuration, duration);
    }

    public List<String> getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public boolean isSupportedProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol);
    }

    public void addSupportedProtocol(String protocol) {
        String trimmed = StringSupport.trimOrNull((String)protocol);
        if (trimmed != null && !this.supportedProtocols.contains(trimmed)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.add(trimmed);
        }
    }

    public void removeSupportedProtocol(String protocol) {
        String trimmed = StringSupport.trimOrNull((String)protocol);
        if (trimmed != null && this.supportedProtocols.contains(trimmed)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.remove(trimmed);
        }
    }

    public void removeSupportedProtocols(Collection<String> protocols) {
        for (String protocol : protocols) {
            this.removeSupportedProtocol(protocol);
        }
    }

    public void removeAllSupportedProtocols() {
        this.supportedProtocols.clear();
    }

    public String getErrorURL() {
        return this.errorURL;
    }

    public void setErrorURL(String url) {
        this.errorURL = this.prepareForAssignment(this.errorURL, url);
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extensions ext) {
        this.extensions = (Extensions)this.prepareForAssignment((XMLObject)this.extensions, (XMLObject)ext);
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization org) {
        this.organization = (Organization)this.prepareForAssignment((XMLObject)this.organization, (XMLObject)org);
    }

    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public List<KeyDescriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        if (this.extensions != null) {
            children.add(this.getExtensions());
        }
        children.addAll(this.getKeyDescriptors());
        if (this.organization != null) {
            children.add(this.getOrganization());
        }
        children.addAll(this.getContactPersons());
        return Collections.unmodifiableList(children);
    }
}

