/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.net.URI;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSubjectConfirmationToSubjects
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddSubjectConfirmationToSubjects.class);
    @Nonnull
    private final SAMLObjectBuilder<Subject> subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Subject.DEFAULT_ELEMENT_NAME);
    @Nonnull
    private final SAMLObjectBuilder<SubjectConfirmation> confirmationBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
    @Nonnull
    private final SAMLObjectBuilder<SubjectConfirmationData> confirmationDataBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
    private boolean overwriteExisting = true;
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = new MessageLookup(Response.class).compose((Function)new OutboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> addressLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> inResponseToLookupStrategy = new Function<ProfileRequestContext, String>(){

        @Override
        public String apply(ProfileRequestContext input) {
            if (AddSubjectConfirmationToSubjects.this.response != null && AddSubjectConfirmationToSubjects.this.response.getInResponseTo() != null) {
                AddSubjectConfirmationToSubjects.this.log.debug("{} Setting confirmation data InResponseTo to {}", (Object)AddSubjectConfirmationToSubjects.this.getLogPrefix(), (Object)AddSubjectConfirmationToSubjects.this.response.getInResponseTo());
                return AddSubjectConfirmationToSubjects.this.response.getInResponseTo();
            }
            AddSubjectConfirmationToSubjects.this.log.debug("{} Setting confirmation data InResponseTo to (none)", (Object)AddSubjectConfirmationToSubjects.this.getLogPrefix());
            return null;
        }
    };
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy = new Function<ProfileRequestContext, String>(){

        @Override
        public String apply(ProfileRequestContext input) {
            if (input.getOutboundMessageContext() != null) {
                try {
                    URI uri = SAMLBindingSupport.getEndpointURL((MessageContext)input.getOutboundMessageContext());
                    if (uri != null) {
                        String url = uri.toString();
                        AddSubjectConfirmationToSubjects.this.log.debug("{} Setting confirmation data Recipient to {}", (Object)AddSubjectConfirmationToSubjects.this.getLogPrefix(), (Object)url);
                        return url;
                    }
                }
                catch (BindingException e) {
                    AddSubjectConfirmationToSubjects.this.log.debug("{} Error getting response endpoint", (Object)AddSubjectConfirmationToSubjects.this.getLogPrefix(), (Object)e);
                }
            }
            AddSubjectConfirmationToSubjects.this.log.debug("{} Setting confirmation data Recipient to (none)", (Object)AddSubjectConfirmationToSubjects.this.getLogPrefix());
            return null;
        }
    };
    @Nullable
    private Function<ProfileRequestContext, Long> lifetimeLookupStrategy = new Function<ProfileRequestContext, Long>(){

        @Override
        public Long apply(ProfileRequestContext input) {
            AddSubjectConfirmationToSubjects.this.log.debug("{} Setting confirmation data NotOnOrAfter to 5 minutes from now", (Object)AddSubjectConfirmationToSubjects.this.getLogPrefix());
            return 300000L;
        }
    };
    @NonnullAfterInit
    private String confirmationMethod;
    @Nullable
    private Response response;

    public void setOverwriteExisting(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.overwriteExisting = flag;
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setAddressLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.addressLookupStrategy = strategy;
    }

    public void setInResponseToLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.inResponseToLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientLookupStrategy = strategy;
    }

    public void setLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lifetimeLookupStrategy = strategy;
    }

    public void setMethod(@Nonnull @NotEmpty String method) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.confirmationMethod = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)method), (String)"Confirmation method cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.confirmationMethod == null) {
            throw new ComponentInitializationException("Confirmation method cannot be null or empty");
        }
        if (this.addressLookupStrategy == null) {
            this.addressLookupStrategy = new RemoteAddressStrategy();
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Attempting to add SubjectConfirmation to assertions in outgoing Response", (Object)this.getLogPrefix());
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No SAML response located in current profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (this.response.getAssertions().isEmpty()) {
            this.log.debug("{} No assertions in response message, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Long lifetime;
        String recipient;
        String inResponseTo;
        SubjectConfirmation confirmation = (SubjectConfirmation)this.confirmationBuilder.buildObject();
        confirmation.setMethod(this.confirmationMethod);
        SubjectConfirmationData confirmationData = null;
        String address = this.addressLookupStrategy.apply(profileRequestContext);
        if (address != null) {
            confirmationData = confirmationData != null ? confirmationData : (SubjectConfirmationData)this.confirmationDataBuilder.buildObject();
            confirmationData.setAddress(address);
        }
        String string = inResponseTo = this.inResponseToLookupStrategy != null ? this.inResponseToLookupStrategy.apply(profileRequestContext) : null;
        if (inResponseTo != null) {
            confirmationData = confirmationData != null ? confirmationData : (SubjectConfirmationData)this.confirmationDataBuilder.buildObject();
            confirmationData.setInResponseTo(inResponseTo);
        }
        String string2 = recipient = this.recipientLookupStrategy != null ? this.recipientLookupStrategy.apply(profileRequestContext) : null;
        if (recipient != null) {
            confirmationData = confirmationData != null ? confirmationData : (SubjectConfirmationData)this.confirmationDataBuilder.buildObject();
            confirmationData.setRecipient(recipient);
        }
        Long l = lifetime = this.lifetimeLookupStrategy != null ? this.lifetimeLookupStrategy.apply(profileRequestContext) : null;
        if (lifetime != null) {
            confirmationData = confirmationData != null ? confirmationData : (SubjectConfirmationData)this.confirmationDataBuilder.buildObject();
            confirmationData.setNotOnOrAfter(Instant.now().plusMillis(lifetime));
        }
        if (confirmationData != null) {
            confirmation.setSubjectConfirmationData(confirmationData);
        }
        int count = 0;
        for (Assertion assertion : this.response.getAssertions()) {
            Subject subject = this.getAssertionSubject(assertion);
            if (this.overwriteExisting) {
                subject.getSubjectConfirmations().clear();
            }
            subject.getSubjectConfirmations().add(count > 0 ? this.cloneConfirmation(confirmation) : confirmation);
            ++count;
        }
        if (count > 0) {
            this.log.debug("{} Added SubjectConfirmation with method {} to {} assertion(s)", new Object[]{this.getLogPrefix(), this.confirmationMethod, count});
        }
    }

    @Nonnull
    private Subject getAssertionSubject(@Nonnull Assertion assertion) {
        if (assertion.getSubject() != null) {
            return assertion.getSubject();
        }
        Subject subject = (Subject)this.subjectBuilder.buildObject();
        assertion.setSubject(subject);
        return subject;
    }

    @Nonnull
    private SubjectConfirmation cloneConfirmation(@Nonnull SubjectConfirmation confirmation) {
        SubjectConfirmation clone = (SubjectConfirmation)this.confirmationBuilder.buildObject();
        clone.setMethod(confirmation.getMethod());
        SubjectConfirmationData data = confirmation.getSubjectConfirmationData();
        if (data != null) {
            SubjectConfirmationData cloneData = (SubjectConfirmationData)this.confirmationDataBuilder.buildObject();
            cloneData.setAddress(data.getAddress());
            cloneData.setInResponseTo(data.getInResponseTo());
            cloneData.setRecipient(data.getRecipient());
            cloneData.setNotBefore(data.getNotBefore());
            cloneData.setNotOnOrAfter(data.getNotOnOrAfter());
            clone.setSubjectConfirmationData(cloneData);
        }
        return clone;
    }

    private class RemoteAddressStrategy
    implements Function<ProfileRequestContext, String> {
        private RemoteAddressStrategy() {
        }

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext t) {
            if (AddSubjectConfirmationToSubjects.this.getHttpServletRequest() != null) {
                return HttpServletSupport.getRemoteAddr((ServletRequest)AddSubjectConfirmationToSubjects.this.getHttpServletRequest());
            }
            return null;
        }
    }
}

