/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.core;

import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.FrontEndGenerator;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.VelocityGenerator;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.util.OutputStreamCreator;
import org.apache.cxf.version.Version;

public abstract class AbstractGenerator
implements FrontEndGenerator {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractGenerator.class);
    protected ToolContext env;
    protected String name;
    protected VelocityGenerator velocity = new VelocityGenerator(false);

    protected void doWrite(String templateName, Writer outputs) throws ToolException {
        if (outputs != null) {
            this.velocity.doWrite(templateName, outputs);
        }
    }

    protected boolean isCollision(String packageName, String filename) throws ToolException {
        return this.isCollision(packageName, filename, ".java");
    }

    protected boolean isCollision(String packageName, String filename, String ext) throws ToolException {
        if (this.env.optionSet("overwrite")) {
            return false;
        }
        FileWriterUtil fw = new FileWriterUtil((String)this.env.get("outputdir"), null);
        return fw.isCollision(packageName, filename + ext);
    }

    protected boolean wantToKeep() {
        return this.env.optionSet("newonly");
    }

    protected Writer parseOutputName(String packageName, String filename, String ext) throws ToolException {
        Writer writer;
        if (this.wantToKeep() && this.isCollision(packageName, filename, ext)) {
            Message msg = new Message("SKIP_GEN", LOG, new Object[]{packageName + "." + filename + ext});
            LOG.log(Level.INFO, msg.toString());
            return null;
        }
        FileWriterUtil fw = new FileWriterUtil(this.getOutputDir(), (OutputStreamCreator)this.env.get(OutputStreamCreator.class));
        try {
            writer = ".java".equals(ext) ? fw.getWriter(packageName, filename + ext, (String)this.getEnvironment().get("encoding")) : fw.getWriter(packageName, filename + ext);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, new Object[]{packageName + "." + filename + ext});
            throw new ToolException(msg, (Throwable)ioe);
        }
        return writer;
    }

    public abstract void register(ClassCollector var1, String var2, String var3);

    protected Writer parseOutputName(String packageName, String filename) throws ToolException {
        this.register((ClassCollector)this.env.get(ClassCollector.class), packageName, filename);
        return this.parseOutputName(packageName, filename, ".java");
    }

    protected void setAttributes(String n, Object value) {
        this.velocity.setAttributes(n, value);
    }

    protected void setCommonAttributes() {
        this.setAttributes("currentdate", DatatypeConverter.printDateTime((Calendar)Calendar.getInstance()));
        this.setAttributes("version", Version.getCurrentVersion());
        this.setAttributes("fullversion", Version.getCompleteVersionString());
        this.setAttributes("name", Version.getName());
        this.setAttributes("markGenerated", this.env.optionSet("markGenerated"));
        this.setAttributes("suppressGeneratedDate", this.env.optionSet("suppressGeneratedDate"));
        if (this.env.optionSet("frontend")) {
            this.setAttributes("frontend", this.env.get("frontend"));
        }
        if (this.env.optionSet("databinding")) {
            this.setAttributes("databinding", this.env.get("databinding"));
        }
    }

    protected void clearAttributes() {
        this.velocity.clearAttributes();
    }

    public void setEnvironment(ToolContext penv) {
        this.env = penv;
    }

    public ToolContext getEnvironment() {
        return this.env;
    }

    public String getOutputDir() {
        return (String)this.env.get("outputdir");
    }

    public String getName() {
        return this.name;
    }
}

