/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.xnio.FileChangeCallback;
import org.xnio.FileChangeEvent;
import org.xnio.FileSystemWatcher;
import org.xnio._private.Messages;

class PollingFileSystemWatcher
implements FileSystemWatcher,
Runnable {
    private static final AtomicInteger threadIdCounter = new AtomicInteger(0);
    public static final String THREAD_NAME = "xnio-polling-file-watcher";
    private final Map<File, PollHolder> files = Collections.synchronizedMap(new HashMap());
    private final Thread watchThread;
    private final int pollInterval;
    private volatile boolean stopped = false;

    PollingFileSystemWatcher(String name, int pollInterval, boolean daemon) {
        this.watchThread = new Thread((Runnable)this, "xnio-polling-file-watcher[" + name + "]-" + threadIdCounter);
        this.watchThread.setDaemon(daemon);
        this.watchThread.start();
        this.pollInterval = pollInterval;
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                this.doNotify();
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doNotify() {
        for (Map.Entry<File, PollHolder> entry : this.files.entrySet()) {
            Map<File, Long> result = PollingFileSystemWatcher.doScan(entry.getKey());
            List<FileChangeEvent> currentDiff = this.doDiff(result, entry.getValue().currentFileState);
            if (currentDiff.isEmpty()) continue;
            entry.getValue().currentFileState = result;
            for (FileChangeCallback callback : entry.getValue().callbacks) {
                PollingFileSystemWatcher.invokeCallback(callback, currentDiff);
            }
        }
    }

    private List<FileChangeEvent> doDiff(Map<File, Long> newFileState, Map<File, Long> currentFileState) {
        ArrayList<FileChangeEvent> results = new ArrayList<FileChangeEvent>();
        HashMap<File, Long> currentCopy = new HashMap<File, Long>(currentFileState);
        for (Map.Entry<File, Long> entry : newFileState.entrySet()) {
            Long old = (Long)currentCopy.remove(entry.getKey());
            if (old == null) {
                results.add(new FileChangeEvent(entry.getKey(), FileChangeEvent.Type.ADDED));
                continue;
            }
            if (old.equals(entry.getValue()) || entry.getKey().isDirectory()) continue;
            results.add(new FileChangeEvent(entry.getKey(), FileChangeEvent.Type.MODIFIED));
        }
        for (Map.Entry<File, Long> entry : currentCopy.entrySet()) {
            results.add(new FileChangeEvent(entry.getKey(), FileChangeEvent.Type.REMOVED));
        }
        return results;
    }

    @Override
    public synchronized void watchPath(File file, FileChangeCallback callback) {
        PollHolder holder = this.files.get(file);
        if (holder == null) {
            holder = new PollHolder(PollingFileSystemWatcher.doScan(file));
            this.files.put(file, holder);
        }
        holder.callbacks.add(callback);
    }

    @Override
    public synchronized void unwatchPath(File file, FileChangeCallback callback) {
        PollHolder holder = this.files.get(file);
        if (holder != null) {
            holder.callbacks.remove(callback);
            if (holder.callbacks.isEmpty()) {
                this.files.remove(file);
            }
        }
        this.files.remove(file);
    }

    @Override
    public void close() throws IOException {
        this.stopped = true;
        this.watchThread.interrupt();
    }

    static Map<File, Long> doScan(File file) {
        HashMap<File, Long> results = new HashMap<File, Long>();
        ArrayDeque<File> toScan = new ArrayDeque<File>();
        toScan.add(file);
        while (!toScan.isEmpty()) {
            File next = (File)toScan.pop();
            if (next.isDirectory()) {
                results.put(next, next.lastModified());
                File[] list = next.listFiles();
                if (list == null) continue;
                for (File f : list) {
                    toScan.push(new File(f.getAbsolutePath()));
                }
                continue;
            }
            results.put(next, next.lastModified());
        }
        return results;
    }

    static void invokeCallback(FileChangeCallback callback, List<FileChangeEvent> results) {
        try {
            callback.handleChanges(results);
        }
        catch (Exception e) {
            Messages.msg.failedToInvokeFileWatchCallback(e);
        }
    }

    private class PollHolder {
        Map<File, Long> currentFileState;
        final List<FileChangeCallback> callbacks = new ArrayList<FileChangeCallback>();

        private PollHolder(Map<File, Long> currentFileState) {
            this.currentFileState = currentFileState;
        }
    }
}

