/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl.dataformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;

public class JournalDeleteRecordTX
extends JournalInternalRecord {
    private final long txID;
    private final long id;
    private final EncodingSupport record;

    public JournalDeleteRecordTX(long txID, long id, EncodingSupport record) {
        this.id = id;
        this.txID = txID;
        this.record = record;
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeByte((byte)15);
        buffer.writeInt(this.fileID);
        buffer.writeByte(this.compactCount);
        buffer.writeLong(this.txID);
        buffer.writeLong(this.id);
        buffer.writeInt(this.record != null ? this.record.getEncodeSize() : 0);
        if (this.record != null) {
            this.record.encode(buffer);
        }
        buffer.writeInt(this.getEncodeSize());
    }

    @Override
    public int getEncodeSize() {
        return 29 + (this.record != null ? this.record.getEncodeSize() : 0) + 1;
    }
}

