/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public abstract class SessionContinuationMessage
extends PacketImpl {
    public static final int SESSION_CONTINUATION_BASE_SIZE = 18;
    protected byte[] body;
    protected boolean continues;

    public SessionContinuationMessage(byte type, byte[] body, boolean continues) {
        super(type);
        this.body = body;
        this.continues = continues;
    }

    public SessionContinuationMessage(byte type) {
        super(type);
    }

    public byte[] getBody() {
        if (this.size <= 0) {
            return new byte[0];
        }
        return this.body;
    }

    public boolean isContinues() {
        return this.continues;
    }

    @Override
    public int expectedEncodeSize() {
        return 18 + (this.body == null ? 0 : this.body.length);
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.body.length);
        buffer.writeBytes(this.body);
        buffer.writeBoolean(this.continues);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        int size = buffer.readInt();
        this.body = new byte[size];
        buffer.readBytes(this.body);
        this.continues = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.body), this.continues);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", body=" + Arrays.toString(this.body));
        sb.append(", continues=" + this.continues);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionContinuationMessage)) {
            return false;
        }
        SessionContinuationMessage other = (SessionContinuationMessage)obj;
        return Arrays.equals(this.body, other.body) && this.continues == other.continues;
    }
}

