/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.util.FileIOUtil;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.replication.ReplicatedLargeMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LargeServerMessageInSync
implements ReplicatedLargeMessage {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final LargeServerMessage mainLM;
    private final StorageManager storageManager;
    private SequentialFile appendFile;
    private boolean syncDone;
    private boolean deleted;

    public LargeServerMessageInSync(StorageManager storageManager) {
        this.mainLM = storageManager.createCoreLargeMessage();
        this.storageManager = storageManager;
    }

    public synchronized void joinSyncedData(ByteBuffer buffer) throws Exception {
        if (this.deleted) {
            return;
        }
        SequentialFile mainSeqFile = this.mainLM.getAppendFile();
        if (!mainSeqFile.isOpen()) {
            mainSeqFile.open();
        }
        try {
            if (this.appendFile != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("joinSyncedData on {}, currentSize on mainMessage={}, appendFile size = {}", new Object[]{this.mainLM, mainSeqFile.size(), this.appendFile.size()});
                }
                FileIOUtil.copyData((SequentialFile)this.appendFile, (SequentialFile)mainSeqFile, (ByteBuffer)buffer);
                this.deleteAppendFile();
            } else {
                logger.trace("joinSyncedData, appendFile is null, ignoring joinSyncedData on {}", (Object)this.mainLM);
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorWhileSyncingData(this.mainLM.toString(), e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("joinedSyncData on {} finished with {}", (Object)this.mainLM, (Object)mainSeqFile.size());
        }
        this.syncDone = true;
    }

    public SequentialFile getSyncFile() throws ActiveMQException {
        return this.mainLM.getAppendFile();
    }

    @Override
    public Message setDurable(boolean durable) {
        this.mainLM.setDurable(durable);
        return this.mainLM.toMessage();
    }

    @Override
    public synchronized Message setMessageID(long id) {
        this.mainLM.setMessageID(id);
        return this.mainLM.toMessage();
    }

    @Override
    public Message getMessage() {
        return this.mainLM.toMessage();
    }

    @Override
    public synchronized void releaseResources(boolean sync, boolean sendEvent) {
        if (logger.isTraceEnabled()) {
            logger.trace("release resources called on {}", (Object)this.mainLM, (Object)new Exception("trace"));
        }
        this.mainLM.releaseResources(sync, sendEvent);
        if (this.appendFile != null && this.appendFile.isOpen()) {
            try {
                this.appendFile.close();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.largeMessageErrorReleasingResources(e);
            }
        }
    }

    @Override
    public synchronized void deleteFile() throws Exception {
        this.deleted = true;
        try {
            this.mainLM.deleteFile();
        }
        finally {
            this.deleteAppendFile();
        }
    }

    private void deleteAppendFile() throws Exception {
        if (this.appendFile != null) {
            if (this.appendFile.isOpen()) {
                this.appendFile.close();
            }
            this.appendFile.delete();
        }
    }

    @Override
    public synchronized void addBytes(byte[] bytes) throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.syncDone) {
            if (logger.isTraceEnabled()) {
                logger.trace("Adding {} towards sync message::{}", (Object)bytes.length, (Object)this.mainLM);
            }
            this.mainLM.addBytes(bytes);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addBytes(bytes.length={}) on message={}", (Object)bytes.length, (Object)this.mainLM);
        }
        if (this.appendFile == null) {
            this.appendFile = this.storageManager.createFileForLargeMessage(this.mainLM.getMessageID(), StorageManager.LargeMessageExtension.SYNC);
        }
        if (!this.appendFile.isOpen()) {
            this.appendFile.open();
        }
        this.storageManager.addBytesToLargeMessage(this.appendFile, this.mainLM.getMessageID(), bytes);
    }
}

