/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.samlsso;

import java.time.Instant;
import java.util.List;
import org.apache.cxf.fediz.core.samlsso.SSOValidatorResponse;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLSSOResponseValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLSSOResponseValidator.class);
    private String issuerIDP;
    private String assertionConsumerURL;
    private String clientAddress;
    private String requestId;
    private String spIdentifier;
    private boolean enforceResponseSigned;
    private boolean enforceAssertionsSigned = true;
    private boolean enforceKnownIssuer = true;
    private ReplayCache replayCache;

    public void setEnforceAssertionsSigned(boolean enforceAssertionsSigned) {
        this.enforceAssertionsSigned = enforceAssertionsSigned;
    }

    public void setEnforceKnownIssuer(boolean enforceKnownIssuer) {
        this.enforceKnownIssuer = enforceKnownIssuer;
    }

    public SSOValidatorResponse validateSamlResponse(Response samlResponse, boolean postBinding) throws WSSecurityException {
        this.validateIssuer(samlResponse.getIssuer());
        if (samlResponse.getAssertions() == null || samlResponse.getAssertions().isEmpty()) {
            LOG.debug("The Response must contain at least one Assertion");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        String destination = samlResponse.getDestination();
        if (samlResponse.isSigned() && (destination == null || !destination.equals(this.assertionConsumerURL))) {
            LOG.debug("The Response must contain a destination that matches the assertion consumer URL");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (this.enforceResponseSigned && !samlResponse.isSigned()) {
            LOG.debug("The Response must be signed!");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        Assertion validAssertion = null;
        Instant sessionNotOnOrAfter = null;
        for (Assertion assertion : samlResponse.getAssertions()) {
            Subject subject;
            if (assertion.getIssuer() == null) {
                LOG.debug("Assertion Issuer must not be null");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
            this.validateIssuer(assertion.getIssuer());
            if (!samlResponse.isSigned() && this.enforceAssertionsSigned && assertion.getSignature() == null) {
                LOG.debug("The enclosed assertions in the SAML Response must be signed");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
            if (assertion.getAuthnStatements() == null || assertion.getAuthnStatements().isEmpty() || !this.validateAuthenticationSubject(subject = assertion.getSubject(), assertion.getID(), postBinding)) continue;
            this.validateAudienceRestrictionCondition(assertion.getConditions());
            validAssertion = assertion;
            for (AuthnStatement authnStatment : assertion.getAuthnStatements()) {
                if (authnStatment.getSessionNotOnOrAfter() == null) continue;
                sessionNotOnOrAfter = authnStatment.getSessionNotOnOrAfter().toDate().toInstant();
            }
        }
        if (validAssertion == null) {
            LOG.debug("The Response did not contain any Authentication Statement that matched the Subject Confirmation criteria");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        SSOValidatorResponse validatorResponse = new SSOValidatorResponse();
        validatorResponse.setResponseId(samlResponse.getID());
        validatorResponse.setSessionNotOnOrAfter(sessionNotOnOrAfter);
        Element assertionElement = validAssertion.getDOM();
        Element clonedAssertionElement = (Element)assertionElement.cloneNode(true);
        validatorResponse.setAssertionElement(clonedAssertionElement);
        validatorResponse.setAssertion(DOM2Writer.nodeToString((Node)clonedAssertionElement));
        return validatorResponse;
    }

    private void validateIssuer(Issuer issuer) throws WSSecurityException {
        if (issuer == null) {
            return;
        }
        if (this.enforceKnownIssuer && this.issuerIDP != null && !this.issuerIDP.startsWith(issuer.getValue())) {
            LOG.debug("Issuer value: " + issuer.getValue() + " does not match issuer IDP: " + this.issuerIDP);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (issuer.getFormat() != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(issuer.getFormat())) {
            LOG.debug("Issuer format is not null and does not equal: urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private boolean validateAuthenticationSubject(Subject subject, String id, boolean postBinding) throws WSSecurityException {
        if (subject.getSubjectConfirmations() == null) {
            return false;
        }
        boolean foundBearerSubjectConf = false;
        for (SubjectConfirmation subjectConf : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConf.getMethod())) continue;
            foundBearerSubjectConf = true;
            this.validateSubjectConfirmation(subjectConf.getSubjectConfirmationData(), id, postBinding);
        }
        return foundBearerSubjectConf;
    }

    private void validateSubjectConfirmation(SubjectConfirmationData subjectConfData, String id, boolean postBinding) throws WSSecurityException {
        if (subjectConfData == null) {
            LOG.debug("Subject Confirmation Data of a Bearer Subject Confirmation is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        String recipient = subjectConfData.getRecipient();
        if (recipient == null || !recipient.equals(this.assertionConsumerURL)) {
            LOG.debug("Recipient " + recipient + " does not match assertion consumer URL " + this.assertionConsumerURL);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (subjectConfData.getNotOnOrAfter() == null || subjectConfData.getNotOnOrAfter().isBeforeNow()) {
            LOG.debug("Subject Conf Data does not contain NotOnOrAfter or it has expired");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (postBinding && this.replayCache != null) {
            if (this.replayCache.contains(id)) {
                Instant expires = subjectConfData.getNotOnOrAfter().toDate().toInstant();
                this.replayCache.add(id, expires);
            } else {
                LOG.debug("Replay attack with token id: " + id);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        if (subjectConfData.getAddress() != null && this.clientAddress != null && !subjectConfData.getAddress().equals(this.clientAddress)) {
            LOG.debug("Subject Conf Data address " + subjectConfData.getAddress() + " does not match client address " + this.clientAddress);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (subjectConfData.getNotBefore() != null) {
            LOG.debug("The Subject Conf Data must not contain a NotBefore timestamp");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (this.requestId != null && !this.requestId.equals(subjectConfData.getInResponseTo())) {
            LOG.debug("The InResponseTo String " + subjectConfData.getInResponseTo() + " does match the original request id " + this.requestId);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private void validateAudienceRestrictionCondition(Conditions conditions) throws WSSecurityException {
        if (conditions == null) {
            LOG.debug("Conditions are null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        List audienceRestrs = conditions.getAudienceRestrictions();
        if (this.spIdentifier != null && !this.matchSaml2AudienceRestriction(this.spIdentifier, audienceRestrs)) {
            LOG.debug("Assertion does not contain unique subject provider identifier " + this.spIdentifier + " in the audience restriction conditions");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private boolean matchSaml2AudienceRestriction(String appliesTo, List<AudienceRestriction> audienceRestrictions) {
        boolean found = false;
        if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
            for (AudienceRestriction audienceRestriction : audienceRestrictions) {
                if (audienceRestriction.getAudiences() == null) continue;
                for (Audience audience : audienceRestriction.getAudiences()) {
                    if (!appliesTo.equals(audience.getAudienceURI())) continue;
                    return true;
                }
            }
        }
        return found;
    }

    public String getIssuerIDP() {
        return this.issuerIDP;
    }

    public void setIssuerIDP(String issuerIDP) {
        this.issuerIDP = issuerIDP;
    }

    public String getAssertionConsumerURL() {
        return this.assertionConsumerURL;
    }

    public void setAssertionConsumerURL(String assertionConsumerURL) {
        this.assertionConsumerURL = assertionConsumerURL;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getSpIdentifier() {
        return this.spIdentifier;
    }

    public void setSpIdentifier(String spIdentifier) {
        this.spIdentifier = spIdentifier;
    }

    public void setReplayCache(ReplayCache replayCache) {
        this.replayCache = replayCache;
    }

    public boolean isEnforceResponseSigned() {
        return this.enforceResponseSigned;
    }

    public void setEnforceResponseSigned(boolean enforceResponseSigned) {
        this.enforceResponseSigned = enforceResponseSigned;
    }
}

