/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop.tokenize;

import java.io.Serializable;
import org.rogach.scallop.tokenize.EOF;
import org.rogach.scallop.tokenize.EOF$;
import org.rogach.scallop.tokenize.Failed$;
import org.rogach.scallop.tokenize.Matched;
import org.rogach.scallop.tokenize.Matched$;
import org.rogach.scallop.tokenize.StringView;
import org.rogach.scallop.tokenize.TokenizationResult;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class ArgumentTokenizer$
implements Serializable {
    private static final Function1<StringView, TokenizationResult> argumentsParser;
    public static final ArgumentTokenizer$ MODULE$;

    private ArgumentTokenizer$() {
    }

    static {
        MODULE$ = new ArgumentTokenizer$();
        Function1 & Serializable inputEnd = (Function1 & Serializable)input -> input.length() == 0 ? Matched$.MODULE$.apply((Seq<String>)package$.MODULE$.Nil(), (StringView)input) : Failed$.MODULE$;
        Function1 & Serializable whitespace = (Function1 & Serializable)input -> {
            int i;
            int l = input.length();
            for (i = 0; i < l && Character.isWhitespace(input.charAt(i)); ++i) {
            }
            return i == 0 ? Failed$.MODULE$ : Matched$.MODULE$.apply((Seq<String>)package$.MODULE$.Nil(), input.substring(i));
        };
        Function1 & Serializable singleQuotedString = (Function1 & Serializable)input -> {
            if (input.length() == 0 || input.charAt(0) != '\'') {
                return Failed$.MODULE$;
            }
            int stringEnd = input.indexOf(39, 1);
            return stringEnd == -1 ? EOF$.MODULE$.apply("'") : Matched$.MODULE$.apply((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)input.extract(1, stringEnd), (List)Nil$.MODULE$))), input.substring(stringEnd + 1));
        };
        Function1 & Serializable doubleQuotedString = (Function1 & Serializable)input -> {
            if (input.length() == 0 || input.charAt(0) != '\"') {
                return Failed$.MODULE$;
            }
            int i = 1;
            int s = 1;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            boolean stringClosed = false;
            while (!bl && i < l) {
                while (i < l && input.charAt(i) != '\\' && input.charAt(i) != '\"') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        StringBuilder stringBuilder = input.charAt(i + 1) == '\\' || input.charAt(i + 1) == '\"' ? b.append(input.charAt(i + 1)) : b.append(input.extract(i, i + 2));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\"') {
                    stringClosed = true;
                    bl = true;
                    continue;
                }
                b.append(input.charAt(i));
                s = ++i;
            }
            if (eofEscaped) {
                return EOF$.MODULE$.apply("escaped char");
            }
            return !stringClosed ? EOF$.MODULE$.apply("\"") : Matched$.MODULE$.apply((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)b.toString(), (List)Nil$.MODULE$))), input.substring(i + 1));
        };
        Function1 & Serializable plainArgument = (Function1 & Serializable)input -> {
            int i = 0;
            int s = 0;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            while (!bl && i < l) {
                while (i < l && !Character.isWhitespace(input.charAt(i)) && input.charAt(i) != '\\' && input.charAt(i) != '\"' && input.charAt(i) != '\'') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (Character.isWhitespace(input.charAt(i))) {
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        b.append(input.charAt(i + 1));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                bl = true;
            }
            if (eofEscaped) {
                return EOF$.MODULE$.apply("escaped char");
            }
            return b.length() == 0 ? Failed$.MODULE$ : Matched$.MODULE$.apply((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)b.toString(), (List)Nil$.MODULE$))), input.substring(i));
        };
        Function1<StringView, TokenizationResult> token = MODULE$.mapResult(MODULE$.repeat(MODULE$.alternatives((List<Function1<StringView, TokenizationResult>>)((List)new .colon.colon((Object)singleQuotedString, (List)new .colon.colon((Object)doubleQuotedString, (List)new .colon.colon((Object)plainArgument, (List)Nil$.MODULE$)))))), (Function1<Seq<String>, Seq<String>>)(Function1 & Serializable)tokens -> (Seq)((SeqOps)new .colon.colon((Object)tokens.mkString(""), (List)Nil$.MODULE$)));
        argumentsParser = MODULE$.alternatives((List<Function1<StringView, TokenizationResult>>)((List)new .colon.colon(MODULE$.seq(MODULE$.seq(MODULE$.repeat(MODULE$.seq(MODULE$.optional((Function1<StringView, TokenizationResult>)whitespace), token)), MODULE$.optional((Function1<StringView, TokenizationResult>)whitespace)), (Function1<StringView, TokenizationResult>)inputEnd), (List)new .colon.colon(MODULE$.seq(MODULE$.optional((Function1<StringView, TokenizationResult>)whitespace), (Function1<StringView, TokenizationResult>)inputEnd), (List)Nil$.MODULE$))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArgumentTokenizer$.class);
    }

    public TokenizationResult tokenize(String input) {
        return (TokenizationResult)argumentsParser.apply((Object)new StringView(input, 0));
    }

    private Function1<StringView, TokenizationResult> optional(Function1<StringView, TokenizationResult> parser) {
        return (Function1 & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply(input);
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return Matched$.MODULE$.apply((Seq<String>)package$.MODULE$.Nil(), (StringView)input);
            }
            TokenizationResult other = tokenizationResult;
            return other;
        };
    }

    private Function1<StringView, TokenizationResult> seq(Function1<StringView, TokenizationResult> parser1, Function1<StringView, TokenizationResult> parser2) {
        return (Function1 & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser1.apply(input);
            if (tokenizationResult instanceof EOF) {
                EOF eof = (EOF)tokenizationResult;
                return eof;
            }
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return Failed$.MODULE$;
            }
            if (tokenizationResult instanceof Matched) {
                Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult);
                Seq<String> seq = matched._1();
                StringView stringView = matched._2();
                Seq<String> tokens1 = seq;
                StringView rest1 = stringView;
                TokenizationResult tokenizationResult2 = (TokenizationResult)parser2.apply((Object)rest1);
                if (tokenizationResult2 instanceof Matched) {
                    Matched matched2 = Matched$.MODULE$.unapply((Matched)tokenizationResult2);
                    Seq<String> seq2 = matched2._1();
                    StringView stringView2 = matched2._2();
                    Seq<String> tokens2 = seq2;
                    StringView rest2 = stringView2;
                    return Matched$.MODULE$.apply((Seq<String>)((Seq)tokens1.$plus$plus(tokens2)), rest2);
                }
                TokenizationResult other = tokenizationResult2;
                return other;
            }
            throw new MatchError((Object)tokenizationResult);
        };
    }

    private Function1<StringView, TokenizationResult> repeat(Function1<StringView, TokenizationResult> parser) {
        return (Function1 & Serializable)input -> MODULE$.repeatImpl(parser, (StringView)input, (List<Seq<String>>)package$.MODULE$.Nil());
    }

    private TokenizationResult repeatImpl(Function1<StringView, TokenizationResult> parser, StringView input, List<Seq<String>> acc) {
        TokenizationResult tokenizationResult;
        while (true) {
            StringView remainingInput;
            if ((tokenizationResult = (TokenizationResult)parser.apply((Object)input)) instanceof EOF) {
                EOF eof = (EOF)tokenizationResult;
                return eof;
            }
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return acc.isEmpty() ? Failed$.MODULE$ : Matched$.MODULE$.apply((Seq<String>)((Seq)acc.reverse().flatten(Predef$.MODULE$.$conforms())), input);
            }
            if (!(tokenizationResult instanceof Matched)) break;
            Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult);
            Seq<String> seq = matched._1();
            StringView stringView = matched._2();
            Seq<String> tokens = seq;
            StringView stringView2 = remainingInput = stringView;
            List list = acc.$colon$colon(tokens);
            input = stringView2;
            acc = list;
        }
        throw new MatchError((Object)tokenizationResult);
    }

    private Function1<StringView, TokenizationResult> alternatives(List<Function1<StringView, TokenizationResult>> parsers) {
        return (Function1 & Serializable)input -> MODULE$.alternativesImpl(parsers, (StringView)input);
    }

    private TokenizationResult alternativesImpl(List<Function1<StringView, TokenizationResult>> parsers, StringView input) {
        List list;
        block4: {
            TokenizationResult tokenizationResult;
            while (true) {
                list = parsers;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return Failed$.MODULE$;
                }
                if (!(list instanceof .colon.colon)) break block4;
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                Function1 parser = (Function1)colon2.head();
                List remainingParsers = list3;
                tokenizationResult = (TokenizationResult)parser.apply((Object)input);
                if (tokenizationResult instanceof EOF) {
                    EOF eof = (EOF)tokenizationResult;
                    return eof;
                }
                if (!Failed$.MODULE$.equals(tokenizationResult)) break;
                parsers = remainingParsers;
            }
            if (tokenizationResult instanceof Matched) {
                Matched matched = (Matched)tokenizationResult;
                return matched;
            }
            throw new MatchError((Object)tokenizationResult);
        }
        throw new MatchError(list);
    }

    private Function1<StringView, TokenizationResult> mapResult(Function1<StringView, TokenizationResult> parser, Function1<Seq<String>, Seq<String>> fn) {
        return (Function1 & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply(input);
            if (tokenizationResult instanceof Matched) {
                Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult);
                Seq<String> seq = matched._1();
                StringView stringView = matched._2();
                Seq<String> tokens = seq;
                StringView rest = stringView;
                return Matched$.MODULE$.apply((Seq<String>)((Seq)fn.apply(tokens)), rest);
            }
            TokenizationResult other = tokenizationResult;
            return other;
        };
    }
}

