/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.validation.schematron;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.daffodil.api.validation.ValidatorInitializationException;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.DFDLCatalogResolver$;
import org.apache.daffodil.validation.schematron.SchSource;
import org.apache.daffodil.validation.schematron.SchSource$;
import org.apache.daffodil.validation.schematron.SchematronValidator;
import org.apache.daffodil.validation.schematron.SchematronValidator$;
import org.apache.daffodil.validation.schematron.SchematronValidator$ConfigKeys$;
import org.apache.daffodil.validation.schematron.Transforms$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.ModuleSerializationProxy;

public final class SchematronValidatorFactory$
implements Serializable {
    public static final SchematronValidatorFactory$ MODULE$ = new SchematronValidatorFactory$();

    private SchematronValidatorFactory$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SchematronValidatorFactory$.class);
    }

    public SchematronValidator makeValidator(Properties config) {
        InputStream inputStream;
        String schPathValue = config.getProperty(SchematronValidator$.MODULE$.name());
        if (Misc$.MODULE$.isNullOrBlank(schPathValue)) {
            throw new ValidatorInitializationException("invalid configuration: schematron property is empty or not defined");
        }
        URL schUrl = new URL(schPathValue);
        try {
            inputStream = schUrl.openStream();
        }
        catch (Exception exception) {
            throw new ValidatorInitializationException("schematron resource not found: " + schUrl);
        }
        InputStream schStream = inputStream;
        String svrl = config.getProperty(SchematronValidator$ConfigKeys$.MODULE$.svrlOutputFile());
        None$ svrlOutPath = svrl != null ? Some$.MODULE$.apply((Object)new URI(svrl)) : None$.MODULE$;
        return this.makeValidator(schStream, schUrl.toString(), SchSource$.MODULE$.from(schUrl), (Option<URI>)svrlOutPath);
    }

    public SchematronValidator makeValidator(InputStream schematron, String schematronId, SchSource srcfmt) {
        return this.makeValidator(schematron, schematronId, srcfmt, (Option<URI>)None$.MODULE$);
    }

    public SchematronValidator makeValidator(InputStream schematron, String schematronID, SchSource srcfmt, Option<URI> svrlPath) {
        SchematronValidator schematronValidator;
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        factory.setURIResolver((URIResolver)DFDLCatalogResolver$.MODULE$.get());
        try {
            Templates rules = Transforms$.MODULE$.from(schematron, schematronID, srcfmt, (TransformerFactory)factory);
            schematronValidator = new SchematronValidator(rules, svrlPath);
        }
        catch (Exception e) {
            throw new ValidatorInitializationException("failed to create schematron validator: " + e.getMessage());
        }
        return schematronValidator;
    }
}

