/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.LookaheadIteratorImpl;
import net.sf.saxon.value.EmptySequence;

public class OuterForExpression
extends ForExpression {
    @Override
    protected int getRangeVariableCardinality() {
        return 24576;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression sequence0 = this.getSequence();
        this.getSequenceOp().optimize(visitor, contextItemType);
        Expression action0 = this.getAction();
        this.getActionOp().optimize(visitor, contextItemType);
        if (sequence0 != this.getSequence() || action0 != this.getAction()) {
            return this.optimize(visitor, contextItemType);
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        OuterForExpression forExp = new OuterForExpression();
        ExpressionTool.copyLocationInfo(this, forExp);
        forExp.setRequiredType(this.requiredType);
        forExp.setVariableQName(this.variableName);
        forExp.setSequence(this.getSequence().copy(rebindings));
        rebindings.put(this, forExp);
        Expression newAction = this.getAction().copy(rebindings);
        forExp.setAction(newAction);
        forExp.variableName = this.variableName;
        return forExp;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        OuterForExpression.dispatchTailCall(this.makeElaborator().elaborateForPush().processLeavingTail(output, context));
    }

    @Override
    public String getExpressionName() {
        return "outerFor";
    }

    @Override
    protected String allowingEmptyString() {
        return " allowing empty";
    }

    @Override
    protected void explainSpecializedAttributes(ExpressionPresenter out) {
        out.emitAttribute("outer", "true");
    }

    @Override
    public Elaborator getElaborator() {
        return new OuterForExprElaborator();
    }

    public static class OuterForExprElaborator
    extends PullElaborator {
        @Override
        public PullEvaluator elaborateForPull() {
            ForExpression expr = (ForExpression)this.getExpression();
            PullEvaluator selectEval = expr.getSequence().makeElaborator().elaborateForPull();
            int actionCardinality = expr.getAction().getCardinality();
            int slot = expr.getLocalSlotNumber();
            PullEvaluator actionEval = expr.getAction().makeElaborator().elaborateForPull();
            return context -> {
                SequenceIterator base = selectEval.iterate(context);
                LookaheadIterator ahead = LookaheadIteratorImpl.makeLookaheadIterator(base);
                if (ahead.hasNext()) {
                    return MappingIterator.map(ahead, item -> {
                        context.setLocalVariable(slot, item);
                        return actionEval.iterate(context);
                    });
                }
                context.setLocalVariable(slot, EmptySequence.getInstance());
                return actionEval.iterate(context);
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            ForExpression expr = (ForExpression)this.getExpression();
            PullEvaluator selectEval = expr.getSequence().makeElaborator().elaborateForPull();
            PushEvaluator actionEval = expr.getAction().makeElaborator().elaborateForPush();
            int slot = expr.getLocalSlotNumber();
            return (output, context) -> {
                SequenceIterator base = selectEval.iterate(context);
                LookaheadIterator ahead = LookaheadIteratorImpl.makeLookaheadIterator(base);
                if (ahead.hasNext()) {
                    Item item;
                    while ((item = ahead.next()) != null) {
                        context.setLocalVariable(slot, item);
                        Expression.dispatchTailCall(actionEval.processLeavingTail(output, context));
                    }
                } else {
                    context.setLocalVariable(slot, EmptySequence.getInstance());
                    Expression.dispatchTailCall(actionEval.processLeavingTail(output, context));
                }
                return null;
            };
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            ForExpression expr = (ForExpression)this.getExpression();
            PullEvaluator selectEval = expr.getSequence().makeElaborator().elaborateForPull();
            UpdateEvaluator actionEval = expr.getAction().makeElaborator().elaborateForUpdate();
            int slot = expr.getLocalSlotNumber();
            return (context, pul) -> {
                SequenceIterator base = selectEval.iterate(context);
                LookaheadIterator ahead = LookaheadIteratorImpl.makeLookaheadIterator(base);
                if (ahead.hasNext()) {
                    Item item;
                    while ((item = ahead.next()) != null) {
                        context.setLocalVariable(slot, item);
                        actionEval.registerUpdates(context, pul);
                    }
                } else {
                    context.setLocalVariable(slot, EmptySequence.getInstance());
                    actionEval.registerUpdates(context, pul);
                }
            };
        }
    }
}

