/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.util;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.daffodil.api.ParseResult;
import org.apache.daffodil.core.util.FuzzData;
import org.apache.daffodil.core.util.TestUtils$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.xml.XMLUtils;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.parsers.ParseError;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.mutable.HashSet;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.Node;

public class FuzzParseTester {
    private final Elem expected;
    private final FuzzData fuzzer;
    private final DataProcessor p;
    private final HashSet unexpectedThrowClasses;
    private final HashSet okParses;

    public FuzzParseTester(Elem sch, byte[] data, Elem expected, FuzzData fuzzer) {
        this.expected = expected;
        this.fuzzer = fuzzer;
        this.p = TestUtils$.MODULE$.compileSchema((Node)sch);
        this.unexpectedThrowClasses = new HashSet();
        this.okParses = new HashSet();
    }

    public HashSet<Class<? extends Throwable>> unexpectedThrowClasses() {
        return this.unexpectedThrowClasses;
    }

    public HashSet<Tuple3<Node, byte[], XMLUtils.XMLDifferenceException>> okParses() {
        return this.okParses;
    }

    public void handleParseError(ParseError p, byte[] testData, int i) {
    }

    public void handleThrow(Throwable t) {
        this.unexpectedThrowClasses().$plus$eq(t.getClass());
    }

    public void handleUnexpectedSuccess(Node actual, byte[] testData, XMLUtils.XMLDifferenceException diff) {
        if (this.okParses().size() <= 10) {
            this.okParses().$plus$eq((Object)Tuple3$.MODULE$.apply((Object)actual, (Object)testData, (Object)diff));
            return;
        }
    }

    public void run(int nTrials) {
        if (nTrials < 1) {
            throw Assert$.MODULE$.usageError("nTrials.>=(1)");
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), nTrials).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Tuple2 tuple2;
            Tuple2 tuple22;
            byte[] testData = this.fuzzer.next();
            ByteArrayInputStream bais = new ByteArrayInputStream(testData);
            try {
                tuple22 = TestUtils$.MODULE$.runDataProcessorOnInputStream(this.p, bais, false);
            }
            catch (ParseError p) {
                this.handleParseError(p, testData, i);
                tuple22 = Tuple2$.MODULE$.apply(null, null);
            }
            catch (Throwable t) {
                this.handleThrow(t);
                tuple22 = tuple2 = Tuple2$.MODULE$.apply(null, null);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ParseResult pr = (ParseResult)tuple2._1();
            Node node = (Node)tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)pr, (Object)node);
            ParseResult pr2 = (ParseResult)tuple23._1();
            Node node2 = (Node)tuple23._2();
            if (pr2 != null) {
                try {
                    XMLUtils$.MODULE$.compareAndReport((Node)this.expected, node2, XMLUtils$.MODULE$.compareAndReport$default$3(), XMLUtils$.MODULE$.compareAndReport$default$4(), XMLUtils$.MODULE$.compareAndReport$default$5(), XMLUtils$.MODULE$.compareAndReport$default$6(), XMLUtils$.MODULE$.compareAndReport$default$7());
                }
                catch (XMLUtils.XMLDifferenceException e) {
                    this.handleUnexpectedSuccess(node2, testData, e);
                }
                return;
            }
        });
    }
}

