/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MStack$;
import org.apache.daffodil.lib.util.MStack$Mark$;
import org.apache.daffodil.lib.util.ResettableIterator;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public abstract class MStack<T> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MStack.class.getDeclaredField("iter$lzy2"));
    private final Function1<Object, Object> arrayAllocator;
    private final T nullValue;
    private int index;
    private Object table;
    private volatile Object iter$lzy2;

    public static int nullMark() {
        return MStack$.MODULE$.nullMark();
    }

    public MStack(Function1<Object, Object> arrayAllocator, T nullValue) {
        this.arrayAllocator = arrayAllocator;
        this.nullValue = nullValue;
        this.index = 0;
        this.table = null;
    }

    public int org$apache$daffodil$lib$util$MStack$$index() {
        return this.index;
    }

    private void index_$eq(int x$0) {
        this.index = x$0;
    }

    public Object org$apache$daffodil$lib$util$MStack$$table() {
        return this.table;
    }

    private void table_$eq(Object x$0) {
        this.table = x$0;
    }

    public void init() {
        this.index_$eq(0);
        this.table_$eq(this.arrayAllocator.apply((Object)BoxesRunTime.boxToInteger((int)32)));
    }

    public void copyFrom(MStack<T> other) {
        this.index_$eq(other.org$apache$daffodil$lib$util$MStack$$index());
        if (ScalaRunTime$.MODULE$.array_length(this.org$apache$daffodil$lib$util$MStack$$table()) < other.org$apache$daffodil$lib$util$MStack$$index()) {
            this.table_$eq(ScalaRunTime$.MODULE$.array_clone(other.org$apache$daffodil$lib$util$MStack$$table()));
            return;
        }
        for (int i = 0; i < other.org$apache$daffodil$lib$util$MStack$$index(); ++i) {
            ScalaRunTime$.MODULE$.array_update(this.org$apache$daffodil$lib$util$MStack$$table(), i, ScalaRunTime$.MODULE$.array_apply(other.org$apache$daffodil$lib$util$MStack$$table(), i));
        }
    }

    public String toString() {
        Object object = Predef$.MODULE$.genericArrayOps(this.org$apache$daffodil$lib$util$MStack$$table());
        Object object2 = Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.take$extension(object, this.org$apache$daffodil$lib$util$MStack$$index()));
        String stackContents = Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.reverse$extension(object2)).mkString(", ");
        return "MStack(top=" + stackContents + ")";
    }

    private Object growArray(Object x) {
        Object y = this.arrayAllocator.apply((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(x) * 2, 1)));
        Array$.MODULE$.copy(x, 0, y, 0, ScalaRunTime$.MODULE$.array_length(x));
        return y;
    }

    public final int mark() {
        return MStack$Mark$.MODULE$.apply(this.org$apache$daffodil$lib$util$MStack$$index());
    }

    public final void reset(int m) {
        this.index_$eq(m);
    }

    public final int length() {
        return this.org$apache$daffodil$lib$util$MStack$$index();
    }

    public final void push(T x) {
        if (this.org$apache$daffodil$lib$util$MStack$$index() == ScalaRunTime$.MODULE$.array_length(this.org$apache$daffodil$lib$util$MStack$$table())) {
            this.table_$eq(this.growArray(this.org$apache$daffodil$lib$util$MStack$$table()));
        }
        ScalaRunTime$.MODULE$.array_update(this.org$apache$daffodil$lib$util$MStack$$table(), this.org$apache$daffodil$lib$util$MStack$$index(), x);
        this.index_$eq(this.org$apache$daffodil$lib$util$MStack$$index() + 1);
    }

    public final T pop() {
        if (this.org$apache$daffodil$lib$util$MStack$$index() == 0) {
            throw Assert$.MODULE$.usageError("Stack empty");
        }
        this.index_$eq(this.org$apache$daffodil$lib$util$MStack$$index() - 1);
        Object x = ScalaRunTime$.MODULE$.array_apply(this.org$apache$daffodil$lib$util$MStack$$table(), this.org$apache$daffodil$lib$util$MStack$$index());
        ScalaRunTime$.MODULE$.array_update(this.org$apache$daffodil$lib$util$MStack$$table(), this.org$apache$daffodil$lib$util$MStack$$index(), this.nullValue);
        return (T)x;
    }

    public final void setTop(T x) {
        if (this.org$apache$daffodil$lib$util$MStack$$index() == 0) {
            throw Assert$.MODULE$.usageError("Stack empty");
        }
        ScalaRunTime$.MODULE$.array_update(this.org$apache$daffodil$lib$util$MStack$$table(), this.org$apache$daffodil$lib$util$MStack$$index() - 1, x);
    }

    public final T top() {
        return (T)ScalaRunTime$.MODULE$.array_apply(this.org$apache$daffodil$lib$util$MStack$$table(), this.org$apache$daffodil$lib$util$MStack$$index() - 1);
    }

    public final T bottom() {
        return (T)ScalaRunTime$.MODULE$.array_apply(this.org$apache$daffodil$lib$util$MStack$$table(), 0);
    }

    public final boolean isEmpty() {
        return this.org$apache$daffodil$lib$util$MStack$$index() == 0;
    }

    public void clear() {
        this.index_$eq(0);
    }

    public List<T> toList() {
        return this.iterator().toList();
    }

    public Iterator<T> iterator() {
        return new ResettableIterator<T>(this){
            private int currentIndex;
            private int initialIndex;
            private final /* synthetic */ MStack $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.currentIndex = $outer.org$apache$daffodil$lib$util$MStack$$index();
                this.initialIndex = $outer.org$apache$daffodil$lib$util$MStack$$index();
            }

            public boolean hasNext() {
                return this.currentIndex > 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw Assert$.MODULE$.usageError("$anon.this.hasNext");
                }
                if (this.initialIndex > this.$outer.org$apache$daffodil$lib$util$MStack$$index()) {
                    throw Assert$.MODULE$.usageError("$anon.this.initialIndex.<=(MStack.this.index)");
                }
                --this.currentIndex;
                return ScalaRunTime$.MODULE$.array_apply(this.$outer.org$apache$daffodil$lib$util$MStack$$table(), this.currentIndex);
            }

            public void reset() {
                this.currentIndex = this.$outer.org$apache$daffodil$lib$util$MStack$$index();
                this.initialIndex = this.$outer.org$apache$daffodil$lib$util$MStack$$index();
            }
        };
    }

    public Iterator<T> iter() {
        Object object = this.iter$lzy2;
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Iterator)this.iter$lzyINIT2();
    }

    private Object iter$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.iter$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Iterator<T> iterator = null;
                    Iterator<T> iterator2 = null;
                    try {
                        iterator2 = this.iterator();
                        iterator = iterator2 == null ? LazyVals.NullValue$.MODULE$ : iterator2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, iterator)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.iter$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, iterator);
                            waiting.countDown();
                        }
                    }
                    return iterator2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public static final class Mark
    implements Product,
    Serializable {
        private final int v;

        public static int apply(int n) {
            return MStack$Mark$.MODULE$.apply(n);
        }

        public static int unapply(int n) {
            return MStack$Mark$.MODULE$.unapply(n);
        }

        public static int _1$extension(int n) {
            return MStack$Mark$.MODULE$._1$extension(n);
        }

        public static boolean canEqual$extension(int n, Object object) {
            return MStack$Mark$.MODULE$.canEqual$extension(n, object);
        }

        public static int copy$extension(int n, int n2) {
            return MStack$Mark$.MODULE$.copy$extension(n, n2);
        }

        public static boolean equals$extension(int n, Object object) {
            return MStack$Mark$.MODULE$.equals$extension(n, object);
        }

        public static int hashCode$extension(int n) {
            return MStack$Mark$.MODULE$.hashCode$extension(n);
        }

        public static int productArity$extension(int n) {
            return MStack$Mark$.MODULE$.productArity$extension(n);
        }

        public static Object productElement$extension(int n, int n2) {
            return MStack$Mark$.MODULE$.productElement$extension(n, n2);
        }

        public static String productElementName$extension(int n, int n2) {
            return MStack$Mark$.MODULE$.productElementName$extension(n, n2);
        }

        public static String productPrefix$extension(int n) {
            return MStack$Mark$.MODULE$.productPrefix$extension(n);
        }

        public static String toString$extension(int n) {
            return MStack$Mark$.MODULE$.toString$extension(n);
        }

        public static int copy$default$1$extension(int n) {
            return MStack$Mark$.MODULE$.copy$default$1$extension(n);
        }

        public Mark(int v) {
            this.v = v;
        }

        public int hashCode() {
            return MStack$Mark$.MODULE$.hashCode$extension(this.v());
        }

        public boolean equals(Object x$0) {
            return MStack$Mark$.MODULE$.equals$extension(this.v(), x$0);
        }

        public String toString() {
            return MStack$Mark$.MODULE$.toString$extension(this.v());
        }

        public boolean canEqual(Object that) {
            return MStack$Mark$.MODULE$.canEqual$extension(this.v(), that);
        }

        public int productArity() {
            return MStack$Mark$.MODULE$.productArity$extension(this.v());
        }

        public String productPrefix() {
            return MStack$Mark$.MODULE$.productPrefix$extension(this.v());
        }

        public Object productElement(int n) {
            return MStack$Mark$.MODULE$.productElement$extension(this.v(), n);
        }

        public String productElementName(int n) {
            return MStack$Mark$.MODULE$.productElementName$extension(this.v(), n);
        }

        public int v() {
            return this.v;
        }

        public int copy(int v) {
            return MStack$Mark$.MODULE$.copy$extension(this.v(), v);
        }

        public int copy$default$1() {
            return MStack$Mark$.MODULE$.copy$default$1$extension(this.v());
        }

        public int _1() {
            return MStack$Mark$.MODULE$._1$extension(this.v());
        }
    }
}

