/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.xml;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.xml.DaffodilConstructingLoader$;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.Position$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.xml.Comment;
import scala.xml.Document;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NamespaceBinding$;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.PCData$;
import scala.xml.PrefixedAttribute;
import scala.xml.PrefixedAttribute$;
import scala.xml.ProcInstr;
import scala.xml.SpecialNode;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.include.sax.EncodingHeuristics$;
import scala.xml.parsing.ConstructingParser;

public class DaffodilConstructingLoader
extends ConstructingParser {
    private final URI uri;
    private final ErrorHandler errorHandler;
    private final boolean addPositionAttributes;
    private final boolean normalizeCRLFtoLF;

    public static boolean $lessinit$greater$default$3() {
        return DaffodilConstructingLoader$.MODULE$.$lessinit$greater$default$3();
    }

    public DaffodilConstructingLoader(URI uri, ErrorHandler errorHandler, boolean addPositionAttributes, boolean normalizeCRLFtoLF) {
        this.uri = uri;
        this.errorHandler = errorHandler;
        this.addPositionAttributes = addPositionAttributes;
        this.normalizeCRLFtoLF = normalizeCRLFtoLF;
        BufferedInputStream is = new BufferedInputStream(uri.toURL().openStream());
        String enc = EncodingHeuristics$.MODULE$.readEncodingFromStream((InputStream)is);
        super((Source)Source$.MODULE$.fromInputStream((InputStream)is, enc), true);
        this.lookahead();
    }

    public DaffodilConstructingLoader(URI uri, ErrorHandler errorHandler, boolean addPositionAttributes) {
        this(uri, errorHandler, addPositionAttributes, true);
    }

    public void parseDTD() {
        SAXParseException e = this.makeSAXParseException(this.pos(), "DOCTYPE is disallowed.");
        throw e;
    }

    private SAXParseException makeSAXParseException(int pos, String msg) {
        int line = Position$.MODULE$.line(pos);
        int col = Position$.MODULE$.column(pos);
        SAXParseException exc = new SAXParseException(msg, null, this.uri.toString(), line, col);
        return exc;
    }

    public void reportSyntaxError(int pos, String msg) {
        SAXParseException exc = this.makeSAXParseException(pos, msg);
        this.errorHandler.fatalError(exc);
    }

    /*
     * Unable to fully structure code
     */
    public NodeSeq elem(int pos, String pre, String local, MetaData attrs, NamespaceBinding scope, boolean empty, NodeSeq nodes) {
        block9: {
            nsURI = NS$.MODULE$.apply(scope.getURI(pre));
            if (!local.equalsIgnoreCase("schema")) break block9;
            v0 = nsURI;
            var10_9 = XMLUtils$.MODULE$.XSD_NAMESPACE();
            if (!(v0 == null ? var10_9 != null : v0.equals(var10_9) == false)) ** GOTO lbl-1000
        }
        if (local.equalsIgnoreCase("testSuite")) {
            v1 = nsURI;
            var11_10 = XMLUtils$.MODULE$.TDML_NAMESPACE();
            ** if (v1 != null ? v1.equals((Object)var11_10) == false : var11_10 != null) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v2 = true;
            ** GOTO lbl15
        }
lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
lbl15:
        // 2 sources

        isFileRootNode = v2;
        alreadyHasLineCol = attrs.exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(scala.xml.MetaData ), (Lscala/xml/MetaData;)Z)());
        if (this.addPositionAttributes && !alreadyHasLineCol) {
            withFile = isFileRootNode != false ? new PrefixedAttribute(XMLUtils$.MODULE$.INT_PREFIX(), XMLUtils$.MODULE$.FILE_ATTRIBUTE_NAME(), this.uri.toString(), attrs) : attrs;
            withCol = new PrefixedAttribute(XMLUtils$.MODULE$.INT_PREFIX(), XMLUtils$.MODULE$.COLUMN_ATTRIBUTE_NAME(), BoxesRunTime.boxToInteger((int)Position$.MODULE$.column(pos)).toString(), withFile);
            withLine = new PrefixedAttribute(XMLUtils$.MODULE$.INT_PREFIX(), XMLUtils$.MODULE$.LINE_ATTRIBUTE_NAME(), BoxesRunTime.boxToInteger((int)Position$.MODULE$.line(pos)).toString(), (MetaData)withCol);
            v3 = withLine;
        } else {
            v3 = attrs;
        }
        newAttrs = v3;
        intPrefix = scope.getPrefix(NS$.MODULE$.implicitNStoString(XMLUtils$.MODULE$.INT_NS()));
        if (this.addPositionAttributes && intPrefix == null) {
            v4 = NamespaceBinding$.MODULE$.apply(XMLUtils$.MODULE$.INT_PREFIX(), NS$.MODULE$.implicitNStoString(XMLUtils$.MODULE$.INT_NS()), scope);
        } else {
            if (intPrefix != null) {
                v5 = intPrefix;
                var19_18 = XMLUtils$.MODULE$.INT_PREFIX();
                if (v5 == null ? var19_18 != null : v5.equals(var19_18) == false) {
                    throw Assert$.MODULE$.usageError("intPrefix.==(null).||(intPrefix.==(org.apache.daffodil.lib.xml.XMLUtils.INT_PREFIX))");
                }
            }
            v4 = scope;
        }
        newScope = v4;
        return super.elem(pos, pre, local, newAttrs, newScope, empty, nodes);
    }

    public Text text(int pos, String txt) {
        String newText = this.normalizeCRLFtoLF && txt.contains("\r") ? txt.replaceAll("\r\n", "\n").replaceAll("\r", "\n") : txt;
        return super.text(pos, newText);
    }

    public NodeSeq xCharData() {
        this.xToken((Seq)Predef$.MODULE$.wrapString("[CDATA["));
        return (NodeSeq)this.xTakeUntil((Function2 & Serializable)(pos, s) -> this.xCharData$$anonfun$1(BoxesRunTime.unboxToInt((Object)pos), (String)s), (Function0 & Serializable)() -> this.pos(), "]]>");
    }

    public NodeSeq cdata(int pos, String s) {
        return this.text(pos, s);
    }

    public Comment comment(int pos, String s) {
        return null;
    }

    public ProcInstr procInstr(int pos, String target, String txt) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple3<Option<String>, Option<String>, Option<Object>> parseXMLPrologAttributes(MetaData m) {
        block13: {
            info_ver = None$.MODULE$;
            info_enc = None$.MODULE$;
            info_stdl = None$.MODULE$;
            n = 0;
            var6_6 = m.apply("version");
            if (var6_6 != null) {
                if (var6_6 != null && !(var7_7 = Text$.MODULE$.unapply((Object)var6_6)).isEmpty() && "1.0".equals(var8_8 = (String)var7_7.get())) {
                    info_ver = Some$.MODULE$.apply((Object)"1.0");
                    ++n;
                } else {
                    this.reportSyntaxError("cannot deal with versions != 1.0");
                }
            }
            if ((var9_9 = m.apply("encoding")) != null) {
                if (var9_9 != null && !(var10_10 = Text$.MODULE$.unapply((Object)var9_9)).isEmpty()) {
                    var11_11 = (String)var10_10.get();
                    enc = var11_11;
                    if (!this.isValidIANAEncoding((Seq)Predef$.MODULE$.wrapString(enc))) {
                        this.reportSyntaxError("\"" + enc + "\" is not a valid encoding");
                    } else {
                        info_enc = Some$.MODULE$.apply((Object)enc);
                        ++n;
                    }
                } else {
                    throw new MatchError((Object)var9_9);
                }
            }
            if ((var13_13 = m.apply("standalone")) == null) break block13;
            if (var13_13 == null || (var14_14 = Text$.MODULE$.unapply((Object)var13_13)).isEmpty()) ** GOTO lbl-1000
            var15_15 = (String)var14_14.get();
            var16_16 = var15_15;
            if ("yes".equals(var16_16)) {
                info_stdl = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                ++n;
            } else if ("no".equals(var16_16)) {
                info_stdl = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                ++n;
            } else lbl-1000:
            // 2 sources

            {
                this.reportSyntaxError("either 'yes' or 'no' expected");
            }
        }
        if (m.length() - n != 0) {
            this.reportSyntaxError("only 'version', 'encoding', and 'standalone' attributes are expected in xml prolog. Found: " + m);
        }
        return Tuple3$.MODULE$.apply((Object)info_ver, (Object)info_enc, (Object)info_stdl);
    }

    public Document document() {
        this.doc_$eq(new Document());
        this.dtd_$eq(null);
        NodeSeq children = null;
        if ('<' == this.ch()) {
            this.nextch();
            if ('?' == this.ch()) {
                NamespaceBinding scp;
                this.nextch();
                String name = this.xName();
                this.xSpace();
                Tuple2 tuple2 = this.xAttributes((NamespaceBinding)TopScope$.MODULE$);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                MetaData md = (MetaData)tuple2._1();
                NamespaceBinding scp2 = (NamespaceBinding)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)md, (Object)scp2);
                MetaData md2 = (MetaData)tuple22._1();
                NamespaceBinding namespaceBinding = scp = (NamespaceBinding)tuple22._2();
                TopScope$ topScope$ = TopScope$.MODULE$;
                if (namespaceBinding == null ? topScope$ != null : !namespaceBinding.equals(topScope$)) {
                    this.reportSyntaxError("no xmlns definitions allowed.");
                }
                this.xToken('?');
                this.xToken('>');
                String string = name;
                String string2 = "xml";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Tuple3<Option<String>, Option<String>, Option<Object>> info_prolog = this.parseXMLPrologAttributes(md2);
                    this.doc().version_$eq((Option)info_prolog._1());
                    this.doc().encoding_$eq((Option)info_prolog._2());
                    this.doc().standAlone_$eq((Option)info_prolog._3());
                }
                children = this.content((NamespaceBinding)TopScope$.MODULE$);
            } else {
                NodeBuffer ts = new NodeBuffer();
                this.content1((NamespaceBinding)TopScope$.MODULE$, ts);
                ts.$amp$plus((Object)this.content((NamespaceBinding)TopScope$.MODULE$));
                children = NodeSeq$.MODULE$.fromSeq((Seq)ts);
            }
        } else {
            children = this.content((NamespaceBinding)TopScope$.MODULE$);
        }
        BooleanRef isErr = BooleanRef.create((boolean)false);
        IntRef elemCount = IntRef.create((int)0);
        ObjectRef theNode = ObjectRef.create(null);
        children.foreach((Function1)(JProcedure1 & Serializable)c -> {
            Node node = c;
            if (node instanceof ProcInstr) {
                return;
            }
            if (node instanceof Comment) {
                return;
            }
            if (node instanceof EntityRef) {
                this.reportSyntaxError("no entity references allowed here");
                isErr$1.elem = true;
                return;
            }
            if (node instanceof SpecialNode) {
                SpecialNode s = (SpecialNode)node;
                String txt = s.toString().trim();
                if (txt.length() > 0) {
                    this.reportSyntaxError("non-empty text nodes not allowed: '" + txt + "'.");
                    isErr$1.elem = true;
                    return;
                }
                return;
            }
            if (node instanceof Elem) {
                Elem m = (Elem)node;
                ++elemCount$1.elem;
                theNode$1.elem = m;
                return;
            }
            throw new MatchError((Object)node);
        });
        if (1 != elemCount.elem) {
            this.reportSyntaxError("document must contain exactly one element");
            isErr.elem = true;
        }
        if (!isErr.elem) {
            this.doc().children_$eq((Seq)children);
            this.doc().docElem_$eq((Node)theNode.elem);
            return this.doc();
        }
        return null;
    }

    public Node load() {
        Node node;
        try {
            this.initialize();
            Document doc = this.document();
            node = doc == null ? null : doc.docElem();
        }
        catch (Exception e) {
            SAXParseException exc = this.makeSAXParseException(this.curInput().pos(), e.toString());
            this.errorHandler.fatalError(exc);
            node = null;
        }
        Node res = node;
        return res;
    }

    private static final /* synthetic */ boolean $anonfun$1(MetaData x$1) {
        Some some;
        MetaData metaData = x$1;
        if (metaData instanceof PrefixedAttribute && !(some = PrefixedAttribute$.MODULE$.unapply((PrefixedAttribute)metaData)).isEmpty()) {
            Tuple4 tuple4 = (Tuple4)some.get();
            String string = XMLUtils$.MODULE$.INT_PREFIX();
            Object object = tuple4._1();
            if (!(string != null ? !string.equals(object) : object != null)) {
                String attr = (String)tuple4._2();
                return attr.equalsIgnoreCase(XMLUtils$.MODULE$.COLUMN_ATTRIBUTE_NAME()) || attr.equalsIgnoreCase(XMLUtils$.MODULE$.LINE_ATTRIBUTE_NAME());
            }
        }
        return false;
    }

    private final NodeSeq mkResult$1(int pos, String s) {
        String s1 = this.cdata(pos, s).text();
        return PCData$.MODULE$.apply(s1);
    }

    private final /* synthetic */ NodeSeq xCharData$$anonfun$1(int pos, String s) {
        return this.mkResult$1(pos, s);
    }
}

