/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.io.Serializable;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.MStackOfInt;
import org.apache.daffodil.lib.util.MStackOfInt$;
import org.apache.daffodil.runtime1.infoset.DIArray;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.InfosetWalker$;
import scala.Function0;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class InfosetWalker {
    private final DINode startingContainerNode;
    private final int startingContainerIndex;
    private final InfosetOutputter outputter;
    private final boolean walkHidden;
    private final boolean ignoreBlocks;
    private final boolean releaseUnneededInfoset;
    private final int walkSkipMin;
    private final int walkSkipMax;
    private MStackOf<DINode> containerNodeStack;
    private MStackOfInt containerIndexStack;
    private boolean finished;
    private int walkSkipSize;
    private int walkSkipRemaining;

    public static InfosetWalker apply(DIElement dIElement, InfosetOutputter infosetOutputter, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        return InfosetWalker$.MODULE$.apply(dIElement, infosetOutputter, bl, bl2, bl3, n, n2);
    }

    public static int apply$default$6() {
        return InfosetWalker$.MODULE$.apply$default$6();
    }

    public static int apply$default$7() {
        return InfosetWalker$.MODULE$.apply$default$7();
    }

    public InfosetWalker(DINode startingContainerNode, int startingContainerIndex, InfosetOutputter outputter, boolean walkHidden, boolean ignoreBlocks, boolean releaseUnneededInfoset, int walkSkipMin, int walkSkipMax) {
        this.startingContainerNode = startingContainerNode;
        this.startingContainerIndex = startingContainerIndex;
        this.outputter = outputter;
        this.walkHidden = walkHidden;
        this.ignoreBlocks = ignoreBlocks;
        this.releaseUnneededInfoset = releaseUnneededInfoset;
        this.walkSkipMin = walkSkipMin;
        this.walkSkipMax = walkSkipMax;
        MStackOf<DINode> stack = new MStackOf<DINode>();
        stack.push(startingContainerNode);
        this.containerNodeStack = stack;
        MStackOfInt stack2 = MStackOfInt$.MODULE$.apply();
        stack2.push(BoxesRunTime.boxToInteger((int)(startingContainerIndex - 1)));
        this.containerIndexStack = stack2;
        this.finished = false;
        this.walkSkipRemaining = this.walkSkipSize = walkSkipMin;
    }

    public InfosetOutputter outputter() {
        return this.outputter;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void walk(boolean lastWalk) {
        if (this.finished) {
            throw Assert$.MODULE$.usageError("InfosetWalker.this.finished.unary_!");
        }
        if (this.walkSkipRemaining > 0 && !lastWalk) {
            --this.walkSkipRemaining;
            return;
        }
        boolean canTakeAnotherStep = this.maybeDoStep();
        this.walkSkipRemaining = this.walkSkipSize = canTakeAnotherStep ? this.walkSkipMin : Math.min(this.walkSkipSize << 2, this.walkSkipMax);
        while (canTakeAnotherStep) {
            canTakeAnotherStep = this.maybeDoStep();
        }
    }

    public boolean walk$default$1() {
        return false;
    }

    private boolean maybeDoStep() {
        DINode containerNode = this.containerNodeStack.top();
        int containerIndex = BoxesRunTime.unboxToInt(this.containerIndexStack.top());
        if (containerNode != this.startingContainerNode || containerIndex == this.startingContainerIndex) {
            if (this.ignoreBlocks || this.canTakeStep(containerNode, containerIndex)) {
                this.infosetWalkerStepMove(containerNode, containerIndex);
                return true;
            }
            return false;
        }
        if (containerIndex < this.startingContainerIndex) {
            this.infosetWalkerStepStart();
            return true;
        }
        this.infosetWalkerStepEnd();
        return false;
    }

    private boolean canTakeStep(DINode containerNode, int containerIndex) {
        if (containerNode.infosetWalkerBlockCount() > 0) {
            return false;
        }
        if (containerIndex < containerNode.numChildren()) {
            DINode elem = containerNode.child(containerIndex);
            if (elem.infosetWalkerBlockCount() > 0) {
                return false;
            }
            if (elem.isSimple() && !elem.isFinal()) {
                return false;
            }
            return !elem.isComplex() || elem.numChildren() != 0 || elem.isFinal();
        }
        return containerNode.isFinal();
    }

    private void moveToFirstChild(DINode newContainer) {
        this.containerNodeStack.push(newContainer);
        this.containerIndexStack.push(BoxesRunTime.boxToInteger((int)0));
    }

    private void moveToContainer() {
        this.containerNodeStack.pop();
        this.containerIndexStack.pop();
    }

    private void moveToNextSibling() {
        int top = BoxesRunTime.unboxToInt(this.containerIndexStack.top());
        this.containerIndexStack.setTop(BoxesRunTime.boxToInteger((int)(top + 1)));
    }

    private void doOutputter(Function0<BoxedUnit> outputterFunc, String desc, ThrowsSDE context) {
        try {
            outputterFunc.apply$mcV$sp();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = cause == null ? e.toString() : cause.toString();
            throw context.SDE("Failed to %s: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{desc, msg}));
        }
    }

    private void infosetWalkerStepStart() {
        this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.infosetWalkerStepStart$$anonfun$1();
            return BoxedUnit.UNIT;
        }, "start infoset document", this.startingContainerNode.erd());
        this.moveToNextSibling();
    }

    private void infosetWalkerStepEnd() {
        this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.infosetWalkerStepEnd$$anonfun$1();
            return BoxedUnit.UNIT;
        }, "end infoset document", this.startingContainerNode.erd());
        this.containerNodeStack = null;
        this.containerIndexStack = null;
        this.finished = true;
    }

    private void infosetWalkerStepMove(DINode containerNode, int containerIndex) {
        if (containerIndex < containerNode.numChildren()) {
            DINode child = containerNode.child(containerIndex);
            if (child.isSimple()) {
                if (!child.isHidden() || this.walkHidden) {
                    DISimple simple = (DISimple)child;
                    this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.infosetWalkerStepMove$$anonfun$1(simple);
                        return BoxedUnit.UNIT;
                    }, "start infoset simple element", simple.erd());
                    this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.infosetWalkerStepMove$$anonfun$2(simple);
                        return BoxedUnit.UNIT;
                    }, "end infoset simple element", simple.erd());
                }
                containerNode.freeChildIfNoLongerNeeded(containerIndex, this.releaseUnneededInfoset);
                this.moveToNextSibling();
                return;
            }
            if (!child.isHidden() || this.walkHidden) {
                if (child.isComplex()) {
                    DIComplex complex = (DIComplex)child;
                    this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.infosetWalkerStepMove$$anonfun$3(complex);
                        return BoxedUnit.UNIT;
                    }, "start infoset complex element", complex.erd());
                } else {
                    DIArray array = (DIArray)child;
                    this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.infosetWalkerStepMove$$anonfun$4(array);
                        return BoxedUnit.UNIT;
                    }, "start infoset array", array.erd());
                }
                this.moveToFirstChild(child);
                return;
            }
            this.moveToNextSibling();
            return;
        }
        if (containerNode.isComplex()) {
            DIComplex complex = (DIComplex)containerNode;
            this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.infosetWalkerStepMove$$anonfun$5(complex);
                return BoxedUnit.UNIT;
            }, "end infoset complex element", complex.erd());
        } else {
            DIArray array = (DIArray)containerNode;
            this.doOutputter((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.infosetWalkerStepMove$$anonfun$6(array);
                return BoxedUnit.UNIT;
            }, "end infoset array", array.erd());
        }
        this.moveToContainer();
        this.containerNodeStack.top().freeChildIfNoLongerNeeded(BoxesRunTime.unboxToInt(this.containerIndexStack.top()), this.releaseUnneededInfoset);
        this.moveToNextSibling();
    }

    private final void infosetWalkerStepStart$$anonfun$1() {
        this.outputter().startDocument();
    }

    private final void infosetWalkerStepEnd$$anonfun$1() {
        this.outputter().endDocument();
    }

    private final void infosetWalkerStepMove$$anonfun$1(DISimple simple$1) {
        this.outputter().startSimple(simple$1);
    }

    private final void infosetWalkerStepMove$$anonfun$2(DISimple simple$2) {
        this.outputter().endSimple(simple$2);
    }

    private final void infosetWalkerStepMove$$anonfun$3(DIComplex complex$1) {
        this.outputter().startComplex(complex$1);
    }

    private final void infosetWalkerStepMove$$anonfun$4(DIArray array$1) {
        this.outputter().startArray(array$1);
    }

    private final void infosetWalkerStepMove$$anonfun$5(DIComplex complex$2) {
        this.outputter().endComplex(complex$2);
    }

    private final void infosetWalkerStepMove$$anonfun$6(DIArray array$2) {
        this.outputter().endArray(array$2);
    }
}

