/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;

final class CompactOperations {
    private CompactOperations() {
    }

    static CompactThetaSketch componentsToCompact(long thetaLong, int curCount, short seedHash, boolean srcEmpty, boolean srcCompact, boolean srcOrdered, boolean dstOrdered, MemorySegment dstWSeg, long[] hashArr) {
        boolean dstOrderedOut;
        boolean direct = dstWSeg != null;
        boolean empty = srcEmpty || curCount == 0 && thetaLong == Long.MAX_VALUE;
        boolean single = curCount == 1 && thetaLong == Long.MAX_VALUE;
        long[] hashArrOut = !srcCompact ? CompactOperations.compactCache(hashArr, curCount, thetaLong, dstOrdered) : hashArr;
        if (!srcOrdered && dstOrdered && !empty && !single) {
            Arrays.sort(hashArrOut);
        }
        boolean bl = dstOrderedOut = empty || single ? true : dstOrdered;
        if (direct) {
            int preLongs = CompactOperations.computeCompactPreLongs(empty, curCount, thetaLong);
            int flags = 10;
            flags |= empty ? 4 : 0;
            flags |= dstOrderedOut ? 16 : 0;
            MemorySegment seg = CompactOperations.loadCompactMemorySegment(hashArrOut, seedHash, curCount, thetaLong, dstWSeg, (byte)(flags |= single ? 32 : 0), preLongs);
            return new DirectCompactSketch(seg);
        }
        if (empty) {
            return EmptyCompactSketch.getInstance();
        }
        if (single) {
            return new SingleItemSketch(hashArrOut[0], seedHash);
        }
        return new HeapCompactSketch(hashArrOut, empty, seedHash, curCount, thetaLong, dstOrderedOut);
    }

    static CompactThetaSketch segmentToCompact(MemorySegment srcSeg, boolean dstOrdered, MemorySegment dstWSeg) {
        long[] hashArr;
        boolean dstOrderedOut;
        long thetaLong;
        boolean single;
        int srcPreLongs = PreambleUtil.checkSegPreambleCap(srcSeg);
        int srcSerVer = PreambleUtil.extractSerVer(srcSeg);
        int srcFamId = PreambleUtil.extractFamilyID(srcSeg);
        int srcLgArrLongs = PreambleUtil.extractLgArrLongs(srcSeg);
        int srcFlags = PreambleUtil.extractFlags(srcSeg);
        short srcSeedHash = (short)PreambleUtil.extractSeedHash(srcSeg);
        boolean srcReadOnlyFlag = (srcFlags & 2) > 0;
        boolean srcEmptyFlag = (srcFlags & 4) > 0;
        boolean srcCompactFlag = (srcFlags & 8) > 0;
        boolean srcOrderedFlag = (srcFlags & 0x10) > 0;
        boolean srcSingleFlag = (srcFlags & 0x20) > 0;
        boolean bl = single = srcSingleFlag || SingleItemSketch.checkForSingleItem(srcPreLongs, srcSerVer, srcFamId, srcFlags);
        int curCount = single ? 1 : (srcPreLongs > 1 ? PreambleUtil.extractCurCount(srcSeg) : 0);
        long l = thetaLong = srcPreLongs > 2 ? PreambleUtil.extractThetaLong(srcSeg) : Long.MAX_VALUE;
        if (srcEmptyFlag) assert (curCount == 0 && thetaLong == Long.MAX_VALUE);
        if (single) assert (curCount == 1 && thetaLong == Long.MAX_VALUE);
        CompactOperations.checkFamilyAndFlags(srcFamId, srcCompactFlag, srcReadOnlyFlag);
        boolean bl2 = dstOrderedOut = srcEmptyFlag || single ? true : dstOrdered;
        if (srcEmptyFlag) {
            if (dstWSeg != null) {
                MemorySegment.copy(EmptyCompactSketch.EMPTY_COMPACT_SKETCH_ARR, 0, dstWSeg, ValueLayout.JAVA_BYTE, 0L, 8);
                return new DirectCompactSketch(dstWSeg);
            }
            return EmptyCompactSketch.getInstance();
        }
        if (single) {
            long hash = srcSeg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)(srcPreLongs << 3));
            SingleItemSketch sis = new SingleItemSketch(hash, srcSeedHash);
            if (dstWSeg != null) {
                MemorySegment.copy(sis.toByteArray(), 0, dstWSeg, ValueLayout.JAVA_BYTE, 0L, 16);
                return new DirectCompactSketch(dstWSeg);
            }
            return sis;
        }
        if (srcCompactFlag) {
            hashArr = new long[curCount];
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_LONG_UNALIGNED, srcPreLongs << 3, hashArr, 0, curCount);
        } else {
            int srcCacheLen = 1 << srcLgArrLongs;
            long[] tempHashArr = new long[srcCacheLen];
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_LONG_UNALIGNED, srcPreLongs << 3, tempHashArr, 0, srcCacheLen);
            hashArr = CompactOperations.compactCache(tempHashArr, curCount, thetaLong, dstOrderedOut);
        }
        int flagsOut = 0xA | (dstOrderedOut ? 16 : 0);
        if (dstWSeg != null) {
            MemorySegment tgtSeg = CompactOperations.loadCompactMemorySegment(hashArr, srcSeedHash, curCount, thetaLong, dstWSeg, (byte)flagsOut, srcPreLongs);
            return new DirectCompactSketch(tgtSeg);
        }
        return new HeapCompactSketch(hashArr, srcEmptyFlag, srcSeedHash, curCount, thetaLong, dstOrderedOut);
    }

    private static void checkFamilyAndFlags(int srcFamId, boolean srcCompactFlag, boolean srcReadOnlyFlag) {
        Family srcFamily = Family.idToFamily(srcFamId);
        if (srcCompactFlag ? srcFamily == Family.COMPACT && srcReadOnlyFlag : srcFamily == Family.ALPHA || srcFamily == Family.QUICKSELECT) {
            return;
        }
        throw new SketchesArgumentException("Possible Corruption: Family does not match flags: Family: " + srcFamily.toString() + ", Compact Flag: " + srcCompactFlag + ", ReadOnly Flag: " + srcReadOnlyFlag);
    }

    static MemorySegment loadCompactMemorySegment(long[] compactHashArr, short seedHash, int curCount, long thetaLong, MemorySegment dstWSeg, byte flags, int preLongs) {
        assert (dstWSeg != null && compactHashArr != null);
        int outLongs = preLongs + curCount;
        int outBytes = outLongs << 3;
        int dstBytes = (int)dstWSeg.byteSize();
        if (outBytes > dstBytes) {
            throw new SketchesArgumentException("Insufficient Space in MemorySegment: " + dstBytes + ", Need: " + outBytes);
        }
        byte famID = (byte)Family.COMPACT.getID();
        PreambleUtil.insertPreLongs(dstWSeg, preLongs);
        PreambleUtil.insertSerVer(dstWSeg, 3);
        PreambleUtil.insertFamilyID(dstWSeg, famID);
        dstWSeg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 3L, (short)0);
        PreambleUtil.insertFlags(dstWSeg, flags);
        PreambleUtil.insertSeedHash(dstWSeg, seedHash);
        if (preLongs == 1 && curCount == 1) {
            dstWSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, compactHashArr[0]);
            return dstWSeg;
        }
        if (preLongs > 1) {
            PreambleUtil.insertCurCount(dstWSeg, curCount);
            PreambleUtil.insertP(dstWSeg, 0.0f);
        }
        if (preLongs > 2) {
            PreambleUtil.insertThetaLong(dstWSeg, thetaLong);
        }
        if (curCount > 0) {
            MemorySegment.copy(compactHashArr, 0, dstWSeg, ValueLayout.JAVA_LONG_UNALIGNED, (long)(preLongs << 3), curCount);
        }
        return dstWSeg;
    }

    static long[] compactCache(long[] srcCache, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = srcCache.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        if (j < curCount) {
            throw new SketchesStateException("Possible Corruption: curCount parameter is incorrect.");
        }
        if (dstOrdered && curCount > 1) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static long correctThetaOnCompact(boolean empty, int curCount, long thetaLong) {
        return empty && curCount == 0 ? Long.MAX_VALUE : thetaLong;
    }

    static void checkIllegalCurCountAndEmpty(boolean empty, int curCount) {
        if (empty && curCount != 0) {
            throw new SketchesStateException("Possible corruption. Illegal State: Empty=true and Current Count != 0.");
        }
    }

    static int computeCompactPreLongs(boolean empty, int curCount, long thetaLong) {
        return thetaLong < Long.MAX_VALUE ? 3 : (empty ? 1 : (curCount > 1 ? 2 : 1));
    }

    static boolean isSingleItem(boolean empty, int curCount, long thetaLong) {
        return !empty && curCount == 1 && thetaLong == Long.MAX_VALUE;
    }
}

