/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig;

import org.apache.datasketches.Family;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class PigTestingUtil {
    public static final String LS = System.getProperty("line.separator");

    public static Tuple createTupleFromArray(Object[] in) throws ExecException {
        int len = in.length;
        Tuple tuple = TupleFactory.getInstance().newTuple(len);
        for (int i = 0; i < in.length; ++i) {
            tuple.set(i, in[i]);
        }
        return tuple;
    }

    public static DataByteArray createDbaFromQssRange(int nomSize, int start, int numValues) {
        UpdateSketch skA = UpdateSketch.builder().setNominalEntries(nomSize).build();
        for (int i = start; i < start + numValues; ++i) {
            skA.update((long)i);
        }
        byte[] byteArr = skA.compact(true, null).toByteArray();
        return new DataByteArray(byteArr);
    }

    public static DataByteArray createDbaFromAlphaRange(int nomSize, int start, int numValues) {
        UpdateSketch skA = UpdateSketch.builder().setFamily(Family.ALPHA).setNominalEntries(nomSize).build();
        for (int i = start; i < start + numValues; ++i) {
            skA.update((long)i);
        }
        byte[] byteArr = skA.compact(true, null).toByteArray();
        return new DataByteArray(byteArr);
    }

    static void println(String s) {
    }
}

