/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.pig.cpc.DataToSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();

    @Test
    public void execNullInputTuple() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.exec(null);
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTupleCustomLgK() throws Exception {
        DataToSketch func = new DataToSketch("10");
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgK(), (int)10);
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void execUnsupportedType() throws Exception {
        DataToSketch func = new DataToSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple(new Object()));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    @Test
    public void execVariousTypesOfInput() throws Exception {
        DataToSketch func = new DataToSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        Tuple tupleWithNull = TUPLE_FACTORY.newTuple(1);
        tupleWithNull.set(0, null);
        bag.add(tupleWithNull);
        bag.add(TUPLE_FACTORY.newTuple((Object)1));
        bag.add(TUPLE_FACTORY.newTuple((Object)2));
        bag.add(TUPLE_FACTORY.newTuple((Object)3L));
        bag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        bag.add(TUPLE_FACTORY.newTuple((Object)2.0));
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(new byte[]{1})));
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag)));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)7.0, (double)0.01);
    }

    @Test
    public void accumulator() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.getValue();
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple());
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        bag.add(TUPLE_FACTORY.newTuple((Object)"b"));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
        func.cleanup();
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getInitial()).newInstance();
        Tuple input = TUPLE_FACTORY.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicInitialWithLgK() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getInitial()).getConstructor(String.class).newInstance("10");
        Tuple input = TUPLE_FACTORY.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicInitialWithLgKAndSeed() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getInitial()).getConstructor(String.class, String.class).newInstance("10", "123");
        Tuple input = TUPLE_FACTORY.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicIntermediateNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        Tuple result = (Tuple)func.exec(null);
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateEmptyBag() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        DataBag outerBag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"b"));
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"c"));
        outerBag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)outerBag));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
    }

    @Test
    public void algebraicIntermediateFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    @Test
    public void algebraicIntermediateFromIntermediateCustomLgKAndSeed() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).getConstructor(String.class, String.class).newInstance("10", "123");
        CpcSketch inputSketch = new CpcSketch(10, 123L);
        inputSketch.update("a");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0), 123L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0, (double)0.01);
        Assert.assertEquals((int)sketch.getLgK(), (int)10);
    }

    @Test
    public void algebraicFinalNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(null);
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalEmptyBag() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataBag outerBag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"b"));
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"c"));
        outerBag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)outerBag));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
    }

    @Test
    public void algebraicFinalFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    @Test
    public void algebraicFinalFromIntermediateCustomLgKAndSeed() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).getConstructor(String.class, String.class).newInstance("10", "123");
        CpcSketch inputSketch = new CpcSketch(10, 123L);
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch(result, 123L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
        Assert.assertEquals((int)sketch.getLgK(), (int)10);
    }

    static CpcSketch getSketch(DataByteArray dba) throws Exception {
        return DataToSketchTest.getSketch(dba, 9001L);
    }

    static CpcSketch getSketch(DataByteArray dba, long seed) throws Exception {
        Assert.assertNotNull((Object)dba);
        Assert.assertTrue((dba.size() > 0 ? 1 : 0) != 0);
        return CpcSketch.heapify((byte[])dba.get(), (long)seed);
    }
}

