/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.pig.cpc.GetEstimateAndErrorBounds;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetEstimateAndErrorBoundsTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void nullInputTuple() throws Exception {
        GetEstimateAndErrorBounds func = new GetEstimateAndErrorBounds();
        Tuple result = (Tuple)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        GetEstimateAndErrorBounds func = new GetEstimateAndErrorBounds();
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() throws Exception {
        GetEstimateAndErrorBounds func = new GetEstimateAndErrorBounds();
        CpcSketch sketch = new CpcSketch();
        sketch.update(1L);
        sketch.update(2L);
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void normalCaseWithKappa() throws Exception {
        GetEstimateAndErrorBounds func = new GetEstimateAndErrorBounds("1");
        CpcSketch sketch = new CpcSketch();
        sketch.update(1L);
        sketch.update(2L);
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void normalCaseWithKappaAndSeed() throws Exception {
        GetEstimateAndErrorBounds func = new GetEstimateAndErrorBounds("3", "123");
        CpcSketch sketch = new CpcSketch(12, 123L);
        sketch.update(1L);
        sketch.update(2L);
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void schema() throws Exception {
        GetEstimateAndErrorBounds func = new GetEstimateAndErrorBounds();
        Schema inputSchema = new Schema(new Schema.FieldSchema("Sketch", 50));
        Schema outputSchema = func.outputSchema(inputSchema);
        Assert.assertNotNull((Object)outputSchema);
        Assert.assertEquals((int)outputSchema.size(), (int)1);
        Assert.assertEquals((String)DataType.findTypeName((byte)outputSchema.getField((int)0).type), (String)"tuple");
        Schema innerSchema = outputSchema.getField((int)0).schema;
        Assert.assertEquals((int)innerSchema.size(), (int)3);
        Assert.assertEquals((String)DataType.findTypeName((byte)innerSchema.getField((int)0).type), (String)"double");
        Assert.assertEquals((String)DataType.findTypeName((byte)innerSchema.getField((int)1).type), (String)"double");
        Assert.assertEquals((String)DataType.findTypeName((byte)innerSchema.getField((int)2).type), (String)"double");
    }
}

