/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import java.util.List;
import org.apache.datasketches.pig.sampling.ReservoirSamplingTest;
import org.apache.datasketches.pig.sampling.ReservoirUnion;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReservoirUnionTest {
    @Test
    public void invalidMaxKTest() {
        try {
            new ReservoirUnion("1");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void accumulateTest() {
        try {
            long n = 20L;
            int k = 64;
            Tuple reservoir1 = TupleFactory.getInstance().newTuple(3);
            reservoir1.set(0, (Object)20L);
            reservoir1.set(1, (Object)64);
            reservoir1.set(2, (Object)ReservoirSamplingTest.generateDataBag(20L, 0));
            Tuple reservoir2 = TupleFactory.getInstance().newTuple(3);
            reservoir2.set(0, (Object)20L);
            reservoir2.set(1, (Object)64);
            reservoir2.set(2, (Object)ReservoirSamplingTest.generateDataBag(20L, 20));
            Tuple reservoir3 = TupleFactory.getInstance().newTuple(3);
            reservoir3.set(0, (Object)20L);
            reservoir3.set(1, (Object)64);
            reservoir3.set(2, (Object)ReservoirSamplingTest.generateDataBag(20L, 40));
            DataBag bag1 = BagFactory.getInstance().newDefaultBag();
            bag1.add(reservoir1);
            bag1.add(reservoir2);
            Tuple input1 = TupleFactory.getInstance().newTuple((Object)bag1);
            DataBag bag2 = BagFactory.getInstance().newDefaultBag();
            bag2.add(reservoir3);
            Tuple input2 = TupleFactory.getInstance().newTuple((Object)bag2);
            ReservoirUnion ru = new ReservoirUnion(Integer.toString(64));
            ru.accumulate(input1);
            ru.accumulate(input2);
            Tuple result = ru.getValue();
            Assert.assertEquals((int)result.size(), (int)3, (String)"Unexpected tuple size from UDF");
            Assert.assertEquals((long)((Long)result.get(0)), (long)60L, (String)"Incorrect total number of items seen");
            Assert.assertEquals((int)((Integer)result.get(1)), (int)64, (String)"Unexpected value of k");
            DataBag outputSamples = (DataBag)result.get(2);
            Assert.assertEquals((long)outputSamples.size(), (long)((Long)result.get(0)), (String)"Output reservoir size does not match reported number of items");
            int i = 0;
            for (Tuple t : outputSamples) {
                Assert.assertEquals((int)((Integer)t.get(0)), (int)i);
                Assert.assertEquals((String)((String)t.get(1)), (String)Integer.toString(-i));
                ++i;
            }
            ru.cleanup();
            Assert.assertNull((Object)ru.getValue());
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void checkMaxKLimit() {
        try {
            int k = 64;
            int maxK = 32;
            Tuple reservoir = TupleFactory.getInstance().newTuple(3);
            reservoir.set(0, (Object)64L);
            reservoir.set(1, (Object)64);
            reservoir.set(2, (Object)ReservoirSamplingTest.generateDataBag(64L, 0));
            DataBag inputBag = BagFactory.getInstance().newDefaultBag();
            inputBag.add(reservoir);
            Tuple inputTuple = TupleFactory.getInstance().newTuple((Object)inputBag);
            ReservoirUnion ru = new ReservoirUnion(Integer.toString(32));
            Tuple result = (Tuple)ru.exec(inputTuple);
            Assert.assertEquals((int)result.size(), (int)3, (String)"Unexpected tuple size from UDF");
            Assert.assertEquals((long)((Long)result.get(0)), (long)64L, (String)"Incorrect total number of items seen");
            Assert.assertEquals((int)((Integer)result.get(1)), (int)32, (String)"Unexpected value of k");
            DataBag outputSamples = (DataBag)result.get(2);
            Assert.assertEquals((long)outputSamples.size(), (long)32L, (String)"Output reservoir size does not match maxK");
            for (Tuple t : outputSamples) {
                int i = (Integer)t.get(0);
                Assert.assertTrue((i >= 0 && i < 64 ? 1 : 0) != 0);
                Assert.assertEquals((String)((String)t.get(1)), (String)Integer.toString(-i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void checkDegenerateInput() {
        Tuple inputTuple;
        ReservoirUnion ru = new ReservoirUnion();
        try {
            Assert.assertNull((Object)ru.exec(null));
            inputTuple = TupleFactory.getInstance().newTuple(0);
            Assert.assertNull((Object)ru.exec(inputTuple));
            inputTuple = TupleFactory.getInstance().newTuple(1);
            inputTuple.set(0, null);
            Assert.assertNull((Object)ru.exec(inputTuple));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
        try {
            Tuple reservoir = TupleFactory.getInstance().newTuple(2);
            reservoir.set(0, (Object)256L);
            reservoir.set(1, (Object)256);
            DataBag reservoirBag = BagFactory.getInstance().newDefaultBag();
            reservoirBag.add(reservoir);
            inputTuple = TupleFactory.getInstance().newTuple((Object)reservoirBag);
            ru.exec(inputTuple);
            Assert.fail((String)"Did not catch expected ExecException");
        }
        catch (ExecException reservoir) {
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void outputSchemaTest() throws FrontendException {
        ReservoirUnion ru = new ReservoirUnion("5");
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("field1", 55));
        tupleSchema.add(new Schema.FieldSchema("field2", 10));
        Schema recordSchema = new Schema();
        recordSchema.add(new Schema.FieldSchema("record", tupleSchema, 110));
        Schema sketchSchema = new Schema();
        sketchSchema.add(new Schema.FieldSchema("n", 15));
        sketchSchema.add(new Schema.FieldSchema("k", 10));
        sketchSchema.add(new Schema.FieldSchema("reservoir", recordSchema, 120));
        Schema sketchBagSchema = new Schema(new Schema.FieldSchema("sketch", sketchSchema, 110));
        Schema inputSchema = new Schema(new Schema.FieldSchema("sketchSet", sketchBagSchema, 120));
        Schema output = ru.outputSchema(inputSchema);
        Assert.assertEquals((int)output.size(), (int)1);
        List outputFields = output.getField((int)0).schema.getFields();
        Assert.assertEquals((int)outputFields.size(), (int)3);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)0)).alias, (String)"n");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)0)).type, (byte)15);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)1)).alias, (String)"k");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)1)).type, (byte)10);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)2)).alias, (String)"reservoir");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)2)).type, (byte)120);
        Schema sampleSchema = ((Schema.FieldSchema)outputFields.get((int)2)).schema;
        Assert.assertTrue((boolean)recordSchema.equals((Object)sampleSchema));
    }

    @Test
    public void degenerateSchemaTest() throws FrontendException {
        ReservoirUnion ru = new ReservoirUnion("5");
        Schema output = ru.outputSchema(null);
        Assert.assertNull((Object)output);
        output = ru.outputSchema(new Schema());
        Assert.assertNull((Object)output);
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("field1", 55));
        tupleSchema.add(new Schema.FieldSchema("field2", 10));
        Schema recordSchema = new Schema();
        recordSchema.add(new Schema.FieldSchema("record", tupleSchema, 110));
        output = ru.outputSchema(new Schema());
        Assert.assertNull((Object)output);
    }
}

