/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import java.io.IOException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.pig.cpc.AlgebraicFinal;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

abstract class AlgebraicIntermediate
extends EvalFunc<Tuple> {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private final int lgK_;
    private final long seed_;
    private Tuple emptySketchTuple_;
    private boolean isFirstCall_ = true;

    public AlgebraicIntermediate(int lgK, long seed) {
        this.lgK_ = lgK;
        this.seed_ = seed;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        DataByteArray dba;
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Algebraic was used");
            this.isFirstCall_ = false;
        }
        if ((dba = AlgebraicFinal.process(inputTuple, this.lgK_, this.seed_, this.isInputRaw())) == null) {
            return this.getEmptySketchTuple();
        }
        return TUPLE_FACTORY.newTuple((Object)dba);
    }

    abstract boolean isInputRaw();

    private Tuple getEmptySketchTuple() {
        if (this.emptySketchTuple_ == null) {
            this.emptySketchTuple_ = TUPLE_FACTORY.newTuple((Object)new DataByteArray(new CpcSketch(this.lgK_, this.seed_).toByteArray()));
        }
        return this.emptySketchTuple_;
    }
}

