/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.frequencies;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.pig.frequencies.Util;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;

public abstract class DataToFrequentItemsSketch<T>
extends EvalFunc<Tuple>
implements Accumulator<Tuple> {
    private final int sketchSize_;
    private ItemsSketch<T> accumSketch_;
    private final ArrayOfItemsSerDe<T> serDe_;
    private boolean isFirstCall_ = true;

    public DataToFrequentItemsSketch(int sketchSize, ArrayOfItemsSerDe<T> serDe) {
        this.sketchSize_ = sketchSize;
        this.serDe_ = serDe;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"accumulate was used");
            this.isFirstCall_ = false;
        }
        if (this.accumSketch_ == null) {
            this.accumSketch_ = new ItemsSketch(this.sketchSize_);
        }
        if (inputTuple.size() != 1) {
            throw new IllegalArgumentException("Input tuple must have 1 bag");
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        DataToFrequentItemsSketch.updateSketch(bag, this.accumSketch_);
    }

    public void cleanup() {
        this.accumSketch_ = null;
    }

    public Tuple getValue() {
        Tuple outputTuple;
        if (this.accumSketch_ == null) {
            this.accumSketch_ = new ItemsSketch(this.sketchSize_);
        }
        try {
            outputTuple = Util.serializeSketchToTuple(this.accumSketch_, this.serDe_);
        }
        catch (ExecException ex) {
            throw new RuntimeException("Pig Error: " + ex.getMessage(), ex);
        }
        return outputTuple;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"exec was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return null;
        }
        this.accumulate(inputTuple);
        Tuple outputTuple = this.getValue();
        this.cleanup();
        return outputTuple;
    }

    static <T> void updateSketch(DataBag bag, ItemsSketch<T> sketch) throws ExecException {
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        for (Tuple tuple : bag) {
            if (tuple.size() != 1 && tuple.size() != 2) {
                throw new IllegalArgumentException("Inner tuple of input bag must have 1 or 2 fields.");
            }
            Object key = tuple.get(0);
            if (key == null) continue;
            long value = tuple.size() == 2 ? (Long)tuple.get(1) : 1L;
            sketch.update(key, value);
        }
    }
}

