/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hash;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.hash.MurmurHash3Adaptor;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class MurmurHash3
extends EvalFunc<Tuple> {
    private static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    private int divisor_ = 0;

    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        Tuple out = mTupleFactory.newTuple(3);
        long[] hashOut = this.extractInputs(input);
        if (hashOut == null) {
            return out;
        }
        long h0 = hashOut[0];
        long h1 = hashOut[1];
        int modResult = (long)this.divisor_ > 0L ? MurmurHash3Adaptor.modulo((long)h0, (long)h1, (int)this.divisor_) : -1;
        out.set(0, (Object)h0);
        out.set(1, (Object)h1);
        out.set(2, (Object)modResult);
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long[] extractInputs(Tuple input) throws IOException {
        int sw = Math.min(input.size(), 3);
        long seed = 0L;
        Object obj = null;
        long[] hashOut = null;
        switch (sw) {
            case 3: {
                obj = input.get(2);
                if (obj != null) {
                    if (!(obj instanceof Integer)) throw new IllegalArgumentException("Modulus divisor must be an Integer.");
                    this.divisor_ = (Integer)obj;
                    if (this.divisor_ <= 0) {
                        throw new IllegalArgumentException("Modulus divisor must be greater than zero. " + this.divisor_);
                    }
                }
            }
            case 2: {
                obj = input.get(1);
                if (obj != null) {
                    if (obj instanceof Long) {
                        seed = (Long)obj;
                    } else {
                        if (!(obj instanceof Integer)) throw new IllegalArgumentException("Seed must be an Integer or Long");
                        seed = ((Integer)obj).intValue();
                    }
                }
            }
            case 1: {
                obj = input.get(0);
                byte type = input.getType(0);
                switch (type) {
                    case 1: {
                        return hashOut;
                    }
                    case 10: {
                        long[] data = new long[]{((Integer)obj).intValue()};
                        return org.apache.datasketches.hash.MurmurHash3.hash((long[])data, (long)seed);
                    }
                    case 15: {
                        long[] data = new long[]{(Long)obj};
                        return org.apache.datasketches.hash.MurmurHash3.hash((long[])data, (long)seed);
                    }
                    case 20: {
                        return MurmurHash3Adaptor.hashToLongs((double)((Float)obj).floatValue(), (long)seed);
                    }
                    case 25: {
                        return MurmurHash3Adaptor.hashToLongs((double)((Double)obj), (long)seed);
                    }
                    case 50: {
                        DataByteArray dba = (DataByteArray)obj;
                        if (dba.size() != 0) return org.apache.datasketches.hash.MurmurHash3.hash((byte[])dba.get(), (long)seed);
                        return hashOut;
                    }
                    case 55: {
                        String datum = (String)obj;
                        if (!datum.isEmpty()) return org.apache.datasketches.hash.MurmurHash3.hash((byte[])datum.getBytes(StandardCharsets.UTF_8), (long)seed);
                        return hashOut;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot use this DataType: " + type);
                    }
                }
            }
        }
        return hashOut;
    }

    public Schema outputSchema(Schema input) {
        if (input != null) {
            try {
                Schema tupleSchema = new Schema();
                tupleSchema.add(new Schema.FieldSchema("Hash0", 15));
                tupleSchema.add(new Schema.FieldSchema("Hash1", 15));
                tupleSchema.add(new Schema.FieldSchema("ModuloResult", 10));
                return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
            }
            catch (FrontendException frontendException) {
                // empty catch block
            }
        }
        return null;
    }
}

