/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.VarOptCommonImpl;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class GetVarOptSamples
extends EvalFunc<DataBag> {
    private static final ArrayOfTuplesSerDe SERDE = new ArrayOfTuplesSerDe();

    public DataBag exec(Tuple inputTuple) throws IOException {
        if (inputTuple == null || inputTuple.size() < 1 || inputTuple.isNull(0)) {
            return null;
        }
        DataByteArray dba = (DataByteArray)inputTuple.get(0);
        Memory mem = Memory.wrap((byte[])dba.get());
        VarOptItemsSketch sketch = VarOptItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)SERDE);
        return VarOptCommonImpl.createDataBagFromSketch((VarOptItemsSketch<Tuple>)sketch);
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input == null || input.size() == 0 || input.getField((int)0).type != 50) {
                throw new IllegalArgumentException("Input to GetVarOptSamples must be a DataByteArray: " + (input == null ? "null" : input.toString()));
            }
            Schema weightedSampleSchema = new Schema();
            weightedSampleSchema.add(new Schema.FieldSchema("vo_weight", 25));
            weightedSampleSchema.add(new Schema.FieldSchema("record", 110));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), weightedSampleSchema, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

