/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class JaccardSimilarity
extends EvalFunc<Tuple> {
    private final long seed;

    public JaccardSimilarity() {
        this(9001L);
    }

    public JaccardSimilarity(String seedStr) {
        this(Long.parseLong(seedStr));
    }

    public JaccardSimilarity(long seed) {
        this.seed = seed;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        Object objA = PigUtil.extractFieldAtIndex(inputTuple, 0);
        Sketch sketchA = null;
        if (objA != null) {
            DataByteArray dbaA = (DataByteArray)objA;
            Memory srcMem = Memory.wrap((byte[])dbaA.get());
            sketchA = Sketch.wrap((Memory)srcMem, (long)this.seed);
        }
        Object objB = PigUtil.extractFieldAtIndex(inputTuple, 1);
        Sketch sketchB = null;
        if (objB != null) {
            DataByteArray dbaB = (DataByteArray)objB;
            Memory srcMem = Memory.wrap((byte[])dbaB.get());
            sketchB = Sketch.wrap((Memory)srcMem, (long)this.seed);
        }
        double[] jaccardTupple = org.apache.datasketches.theta.JaccardSimilarity.jaccard(sketchA, sketchB);
        return JaccardSimilarity.doubleArrayToTuple(jaccardTupple);
    }

    private static Tuple doubleArrayToTuple(double[] doubleArray) {
        if (doubleArray == null || doubleArray.length == 0) {
            return null;
        }
        int arraySize = doubleArray.length;
        Tuple outputTuple = TupleFactory.getInstance().newTuple(arraySize);
        for (int i = 0; i < arraySize; ++i) {
            try {
                outputTuple.set(i, (Object)doubleArray[i]);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IOException thrown: " + e);
            }
        }
        return outputTuple;
    }
}

