/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.math.BigDecimal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class NumericConstantNode
extends ConstantNode {
    static final int K_TINYINT = 0;
    static final int K_SMALLINT = 1;
    static final int K_INT = 2;
    static final int K_BIGINT = 3;
    static final int K_DECIMAL = 4;
    static final int K_DOUBLE = 5;
    static final int K_REAL = 6;
    final int kind;

    NumericConstantNode(TypeId t, ContextManager cm) throws StandardException {
        super(cm);
        this.setType(t, this.getPrecision(t, null), this.getScale(t, null), true, this.getMaxWidth(t, null));
        this.kind = this.getKind(t);
    }

    NumericConstantNode(TypeId t, Number value, ContextManager cm) throws StandardException {
        super(cm);
        this.kind = this.getKind(t);
        this.setType(t, this.getPrecision(t, value), this.getScale(t, value), false, this.getMaxWidth(t, value));
        this.setValue(t, value);
    }

    private int getPrecision(TypeId t, Number val) throws StandardException {
        switch (t.getJDBCTypeId()) {
            case -6: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case -5: {
                return 19;
            }
            case 3: {
                if (val != null) {
                    SQLDecimal constantDecimal = new SQLDecimal((BigDecimal)val);
                    return constantDecimal.getDecimalValuePrecision();
                }
                return 31;
            }
            case 8: {
                return 52;
            }
            case 7: {
                return 23;
            }
        }
        SanityManager.NOTREACHED();
        return 0;
    }

    private int getScale(TypeId t, Object val) throws StandardException {
        switch (t.getJDBCTypeId()) {
            case -6: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case -5: {
                return 0;
            }
            case 3: {
                if (val != null) {
                    SQLDecimal constantDecimal = new SQLDecimal((BigDecimal)val);
                    return constantDecimal.getDecimalValueScale();
                }
                return 31;
            }
            case 8: {
                return 0;
            }
            case 7: {
                return 0;
            }
        }
        SanityManager.NOTREACHED();
        return 0;
    }

    private int getMaxWidth(TypeId t, Object val) throws StandardException {
        switch (t.getJDBCTypeId()) {
            case -6: {
                return val != null ? 2 : 0;
            }
            case 4: {
                return val != null ? 4 : 0;
            }
            case 5: {
                return val != null ? 2 : 0;
            }
            case -5: {
                return val != null ? 8 : 0;
            }
            case 3: {
                if (val != null) {
                    SQLDecimal constantDecimal = new SQLDecimal((BigDecimal)val);
                    int precision = constantDecimal.getDecimalValuePrecision();
                    int scal = constantDecimal.getDecimalValueScale();
                    return DataTypeUtilities.computeMaxWidth(precision, scal);
                }
                return 31;
            }
            case 8: {
                return val != null ? 8 : 0;
            }
            case 7: {
                return val != null ? 4 : 0;
            }
        }
        SanityManager.NOTREACHED();
        return 0;
    }

    private int getKind(TypeId t) {
        switch (t.getJDBCTypeId()) {
            case -6: {
                return 0;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
            case -5: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        SanityManager.NOTREACHED();
        return -1;
    }

    private void setValue(TypeId t, Number value) throws StandardException {
        switch (t.getJDBCTypeId()) {
            case -6: {
                this.setValue(new SQLTinyint((Byte)value));
                break;
            }
            case 4: {
                this.setValue(new SQLInteger((Integer)value));
                break;
            }
            case 5: {
                this.setValue(new SQLSmallint((Short)value));
                break;
            }
            case -5: {
                this.setValue(new SQLLongint((Long)value));
                break;
            }
            case 3: {
                this.setValue(new SQLDecimal((BigDecimal)value));
                break;
            }
            case 8: {
                this.setValue(new SQLDouble((Double)value));
                break;
            }
            case 7: {
                this.setValue(new SQLReal((Float)value));
                break;
            }
            default: {
                SanityManager.NOTREACHED();
            }
        }
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getObject();
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        switch (this.kind) {
            case 2: {
                mb.push(this.value.getInt());
                break;
            }
            case 0: {
                mb.push(this.value.getByte());
                break;
            }
            case 1: {
                mb.push(this.value.getShort());
                break;
            }
            case 4: {
                mb.pushNewStart("java.math.BigDecimal");
                mb.push(this.value.getString());
                mb.pushNewComplete(1);
                break;
            }
            case 5: {
                mb.push(this.value.getDouble());
                break;
            }
            case 6: {
                mb.push(this.value.getFloat());
                break;
            }
            case 3: {
                mb.push(this.value.getLong());
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected numeric type = " + this.kind);
            }
        }
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((NumericConstantNode)o).kind == this.kind;
    }
}

