/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.derby.tools.ij;

public class SetQueryTimeoutTest {
    private static final int TIMEOUT = 1;
    private static final int CONNECTIONS = 100;

    private static void printSQLException(SQLException sQLException) {
        while (sQLException != null) {
            sQLException.printStackTrace();
            sQLException = sQLException.getNextException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exec(Connection connection, String string, Collection collection) throws TestFailedException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(string);
        }
        catch (SQLException sQLException) {
            String string2 = sQLException.getSQLState();
            if (!collection.contains(string2)) {
                throw new TestFailedException(sQLException);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    throw new TestFailedException(sQLException);
                }
            }
        }
    }

    private static void exec(Connection connection, String string) throws TestFailedException {
        SetQueryTimeoutTest.exec(connection, string, Collections.EMPTY_SET);
    }

    private static void dropTables(Connection connection, String string) throws TestFailedException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("42Y55");
        SetQueryTimeoutTest.exec(connection, "drop table " + string + "_orig", hashSet);
        SetQueryTimeoutTest.exec(connection, "drop table " + string + "_copy", hashSet);
    }

    private static void prepareTables(Connection connection, String string) throws TestFailedException {
        System.out.println("Initializing tables with prefix " + string);
        SetQueryTimeoutTest.dropTables(connection, string);
        SetQueryTimeoutTest.exec(connection, "create table " + string + "_orig (a int)");
        SetQueryTimeoutTest.exec(connection, "create table " + string + "_copy (a int)");
        SetQueryTimeoutTest.exec(connection, "insert into " + string + "_orig values(0),(1),(2),(3),(4),(5),(6)");
    }

    public static int delay(int n, int n2) throws SQLException {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return n2;
    }

    private static void prepareForTimedQueries(Connection connection) throws TestFailedException {
        System.out.println("Preparing for testing queries with timeout");
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new TestFailedException("Should not happen", sQLException);
        }
        try {
            SetQueryTimeoutTest.exec(connection, "DROP FUNCTION DELAY");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SetQueryTimeoutTest.exec(connection, "CREATE FUNCTION DELAY(SECONDS INTEGER, VALUE INTEGER) RETURNS INTEGER PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbcapi.SetQueryTimeoutTest.delay'");
        SetQueryTimeoutTest.prepareTables(connection, "t");
    }

    private static String getFetchQuery(String string) {
        return "select a from " + string + "_orig where mod(DELAY(1,a),3)=0";
    }

    private static String getExecQuery(String string) {
        return "insert into " + string + "_copy select a from " + string + "_orig where DELAY(1,1)=1";
    }

    private static void expectException(String string, SQLException sQLException, String string2) throws TestFailedException {
        if (sQLException == null) {
            throw new TestFailedException(string2);
        }
        String string3 = sQLException.getSQLState();
        if (!string.equals(string3)) {
            throw new TestFailedException(sQLException);
        }
    }

    private static PreparedStatement prepare(Connection connection, String string) throws TestFailedException {
        try {
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new TestFailedException(sQLException);
        }
    }

    private static void testTimeoutWithFetch(Connection connection, Connection connection2) throws TestFailedException {
        int n;
        System.out.println("Testing timeout with fetch operations");
        try {
            connection.setAutoCommit(false);
            connection2.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new TestFailedException("Should not happen", sQLException);
        }
        PreparedStatement preparedStatement = SetQueryTimeoutTest.prepare(connection, SetQueryTimeoutTest.getFetchQuery("t"));
        PreparedStatement preparedStatement2 = SetQueryTimeoutTest.prepare(connection, SetQueryTimeoutTest.getFetchQuery("t"));
        PreparedStatement preparedStatement3 = SetQueryTimeoutTest.prepare(connection2, SetQueryTimeoutTest.getFetchQuery("t"));
        PreparedStatement preparedStatement4 = SetQueryTimeoutTest.prepare(connection2, SetQueryTimeoutTest.getFetchQuery("t"));
        StatementExecutor[] statementExecutorArray = new StatementExecutor[]{new StatementExecutor(preparedStatement, true, 1), new StatementExecutor(preparedStatement2, true, 0), new StatementExecutor(preparedStatement3, true, 0), new StatementExecutor(preparedStatement4, true, 0)};
        for (n = 3; n >= 0; --n) {
            statementExecutorArray[n].start();
        }
        for (n = 0; n < 4; ++n) {
            try {
                statementExecutorArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                throw new TestFailedException("Should never happen", interruptedException);
            }
        }
        SetQueryTimeoutTest.expectException("XCL52", statementExecutorArray[0].getSQLException(), "fetch did not time out. Highest execution time: " + statementExecutorArray[0].getHighestRunTime() + " ms");
        System.out.println("Statement 0 timed out");
        for (n = 1; n < 4; ++n) {
            SQLException sQLException = statementExecutorArray[n].getSQLException();
            if (sQLException != null) {
                throw new TestFailedException("Unexpected exception in " + n, sQLException);
            }
            System.out.println("Statement " + n + " completed");
        }
        try {
            preparedStatement.close();
            preparedStatement2.close();
            preparedStatement3.close();
            preparedStatement4.close();
            connection.commit();
            connection2.commit();
        }
        catch (SQLException sQLException) {
            throw new TestFailedException(sQLException);
        }
    }

    private static void testTimeoutWithExec(Connection[] connectionArray) throws TestFailedException {
        int n;
        int n2;
        System.out.println("Testing timeout with an execute operation");
        for (int i = 0; i < connectionArray.length; ++i) {
            try {
                connectionArray[i].setAutoCommit(true);
                continue;
            }
            catch (SQLException sQLException) {
                throw new TestFailedException("Should not happen", sQLException);
            }
        }
        PreparedStatement[] preparedStatementArray = new PreparedStatement[connectionArray.length];
        for (int i = 0; i < preparedStatementArray.length; ++i) {
            preparedStatementArray[i] = SetQueryTimeoutTest.prepare(connectionArray[i], SetQueryTimeoutTest.getExecQuery("t"));
        }
        StatementExecutor[] statementExecutorArray = new StatementExecutor[preparedStatementArray.length];
        for (n2 = 0; n2 < statementExecutorArray.length; ++n2) {
            n = n2 % 2 == 0 ? 1 : 0;
            statementExecutorArray[n2] = new StatementExecutor(preparedStatementArray[n2], false, n);
        }
        for (n2 = 0; n2 < statementExecutorArray.length; ++n2) {
            statementExecutorArray[n2].start();
        }
        for (n2 = 0; n2 < statementExecutorArray.length; ++n2) {
            try {
                statementExecutorArray[n2].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                throw new TestFailedException("Should never happen", interruptedException);
            }
        }
        for (n2 = 0; n2 < statementExecutorArray.length; ++n2) {
            int n3 = n = n2 % 2 == 0 ? 1 : 0;
            if (n > 0) {
                SetQueryTimeoutTest.expectException("XCL52", statementExecutorArray[n2].getSQLException(), "exec did not time out. Execution time: " + statementExecutorArray[n2].getHighestRunTime() + " ms");
                continue;
            }
            SQLException sQLException = statementExecutorArray[n2].getSQLException();
            if (sQLException == null) continue;
            throw new TestFailedException(sQLException);
        }
        System.out.println("Statements that should time out timed out, and statements that should complete completed");
        for (n2 = 0; n2 < preparedStatementArray.length; ++n2) {
            try {
                preparedStatementArray[n2].close();
                continue;
            }
            catch (SQLException sQLException) {
                throw new TestFailedException(sQLException);
            }
        }
    }

    private static void testInvalidTimeoutValue(Connection connection) throws TestFailedException {
        System.out.println("Testing setting a negative timeout value");
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new TestFailedException("Should not happen", sQLException);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("select * from sys.systables");
        }
        catch (SQLException sQLException) {
            throw new TestFailedException("Should not happen", sQLException);
        }
        try {
            preparedStatement.setQueryTimeout(-1);
        }
        catch (SQLException sQLException) {
            SetQueryTimeoutTest.expectException("XJ074", sQLException, "negative timeout value should give exception");
        }
        System.out.println("Negative timeout value caused exception, as expected");
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            System.out.println("Execute returned a ResultSet");
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new TestFailedException("Should not happen", sQLException);
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                throw new TestFailedException("close should not throw", sQLException);
            }
        }
    }

    private static void testTimeoutWithExecuteUpdate(Connection connection) throws TestFailedException {
        System.out.println("Testing timeout with executeUpdate call.");
        try {
            Statement statement = connection.createStatement();
            statement.setQueryTimeout(1);
            statement.executeUpdate(SetQueryTimeoutTest.getExecQuery("t"));
        }
        catch (SQLException sQLException) {
            SetQueryTimeoutTest.expectException("XCL52", sQLException, "Should have timed out.");
        }
    }

    private static void testRememberTimeoutValue(Connection connection) throws TestFailedException {
        String string = SetQueryTimeoutTest.getFetchQuery("t");
        try {
            Statement statement = connection.createStatement();
            SetQueryTimeoutTest.testStatementRemembersTimeout(statement);
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            SetQueryTimeoutTest.testStatementRemembersTimeout(preparedStatement);
            CallableStatement callableStatement = connection.prepareCall(string);
            SetQueryTimeoutTest.testStatementRemembersTimeout(callableStatement);
        }
        catch (SQLException sQLException) {
            throw new TestFailedException("Should not happen", sQLException);
        }
    }

    private static void testStatementRemembersTimeout(Statement statement) throws SQLException, TestFailedException {
        System.out.println("Testing that Statement remembers timeout.");
        statement.setQueryTimeout(1);
        long l = 0L;
        for (int i = 0; i < 3; ++i) {
            try {
                long l2 = System.currentTimeMillis();
                ResultSet resultSet = statement.executeQuery(SetQueryTimeoutTest.getFetchQuery("t"));
                while (resultSet.next()) {
                }
                long l3 = System.currentTimeMillis();
                l = l3 - l2;
                throw new TestFailedException("Should have timed out, for statement, iteration: " + i + ", took (millis): " + l);
            }
            catch (SQLException sQLException) {
                SetQueryTimeoutTest.expectException("XCL52", sQLException, "Should have timed out, got unexpected exception, for statement, iteration: " + i + ", time taken (millis): " + l);
                continue;
            }
        }
        statement.close();
    }

    private static void testStatementRemembersTimeout(PreparedStatement preparedStatement) throws SQLException, TestFailedException {
        String string = preparedStatement instanceof CallableStatement ? "CallableStatement" : "PreparedStatement";
        System.out.println("Testing that " + string + " remembers timeout.");
        preparedStatement.setQueryTimeout(1);
        for (int i = 0; i < 3; ++i) {
            long l = 0L;
            try {
                long l2 = System.currentTimeMillis();
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                }
                long l3 = System.currentTimeMillis();
                l = l3 - l2;
                throw new TestFailedException("Should have timed out, for " + string + ", on iteration " + i + ", runtime(millis): " + l);
            }
            catch (SQLException sQLException) {
                SetQueryTimeoutTest.expectException("XCL52", sQLException, "Should have timed out, got unexpected exception, for " + string + ", on iteration " + i + ", runtime(millis): " + l);
                continue;
            }
        }
        preparedStatement.close();
    }

    public static void main(String[] stringArray) {
        new SetQueryTimeoutTest().go(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(String[] stringArray) {
        int n;
        System.out.println("Test SetQueryTimeoutTest starting");
        Connection[] connectionArray = new Connection[100];
        try {
            ij.getPropertyArg((String[])stringArray);
            for (n = 0; n < connectionArray.length; ++n) {
                connectionArray[n] = ij.startJBMS();
            }
            System.out.println("Got connections");
            for (n = 0; n < connectionArray.length; ++n) {
                connectionArray[n].setTransactionIsolation(1);
            }
            SetQueryTimeoutTest.prepareForTimedQueries(connectionArray[0]);
            SetQueryTimeoutTest.testTimeoutWithFetch(connectionArray[0], connectionArray[1]);
            SetQueryTimeoutTest.testTimeoutWithExec(connectionArray);
            SetQueryTimeoutTest.testInvalidTimeoutValue(connectionArray[0]);
            SetQueryTimeoutTest.testRememberTimeoutValue(connectionArray[0]);
            SetQueryTimeoutTest.testTimeoutWithExecuteUpdate(connectionArray[0]);
            System.out.println("Test SetQueryTimeoutTest PASSED");
        }
        catch (Throwable throwable) {
            System.out.println("Test SetQueryTimeoutTest FAILED");
            throwable.printStackTrace();
        }
        finally {
            for (n = connectionArray.length - 1; n >= 0; --n) {
                if (connectionArray[n] == null) continue;
                try {
                    connectionArray[n].close();
                    continue;
                }
                catch (SQLException sQLException) {
                    SetQueryTimeoutTest.printSQLException(sQLException);
                }
            }
            System.out.println("Closed connections");
        }
    }

    public static class StatementExecutor
    extends Thread {
        private PreparedStatement statement;
        private boolean doFetch;
        private int timeout;
        private SQLException sqlException;
        private String name;
        private long highestRunTime;

        public StatementExecutor(PreparedStatement preparedStatement, boolean bl, int n) {
            this.statement = preparedStatement;
            this.doFetch = bl;
            this.timeout = n;
            this.highestRunTime = 0L;
            this.sqlException = null;
            if (n > 0) {
                try {
                    preparedStatement.setQueryTimeout(n);
                }
                catch (SQLException sQLException) {
                    this.sqlException = sQLException;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setHighestRunTime(long l) {
            StatementExecutor statementExecutor = this;
            synchronized (statementExecutor) {
                this.highestRunTime = l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getHighestRunTime() {
            StatementExecutor statementExecutor = this;
            synchronized (statementExecutor) {
                return this.highestRunTime;
            }
        }

        private boolean fetchRow(ResultSet resultSet) throws SQLException {
            long l = System.currentTimeMillis();
            boolean bl = resultSet.next();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 > this.highestRunTime) {
                this.setHighestRunTime(l3);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.sqlException != null) {
                return;
            }
            ResultSet resultSet = null;
            try {
                long l;
                if (this.doFetch) {
                    l = System.currentTimeMillis();
                    resultSet = this.statement.executeQuery();
                    long l2 = System.currentTimeMillis();
                    this.setHighestRunTime(l2 - l);
                    while (this.fetchRow(resultSet)) {
                        StatementExecutor.yield();
                    }
                } else {
                    l = System.currentTimeMillis();
                    this.statement.execute();
                    long l3 = System.currentTimeMillis();
                    this.setHighestRunTime(l3 - l);
                }
            }
            catch (SQLException sQLException) {
                StatementExecutor statementExecutor = this;
                synchronized (statementExecutor) {
                    this.sqlException = sQLException;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        if (this.sqlException != null) {
                            System.err.println("Discarding previous exception");
                            this.sqlException.printStackTrace();
                        }
                        this.sqlException = sQLException;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SQLException getSQLException() {
            StatementExecutor statementExecutor = this;
            synchronized (statementExecutor) {
                return this.sqlException;
            }
        }
    }

    private static class TestFailedException
    extends Exception {
        private Throwable cause;

        public TestFailedException(Throwable throwable) {
            this.cause = throwable;
        }

        public TestFailedException(String string) {
            super(string);
            this.cause = null;
        }

        public TestFailedException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        @Override
        public String toString() {
            if (this.cause != null) {
                return super.toString() + ": " + this.cause.toString();
            }
            return super.toString();
        }

        @Override
        public void printStackTrace() {
            super.printStackTrace();
            if (this.cause != null) {
                if (this.cause instanceof SQLException) {
                    SetQueryTimeoutTest.printSQLException((SQLException)this.cause);
                } else {
                    this.cause.printStackTrace();
                }
            }
        }
    }
}

