/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.tools.JDBCDisplayUtil;

public class dbcleanup {
    static String dbURL = "jdbc:derby:wombat";
    static String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    static boolean dbIsDirty = false;
    int thread_id;
    int ind = 0;

    public static void main(String[] stringArray) throws SQLException, IOException, InterruptedException, Exception {
        dbcleanup.doit(true);
    }

    public static void doit(boolean bl) throws SQLException, IOException, InterruptedException, Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl2 = false;
        Date date = new Date();
        Properties properties = System.getProperties();
        String string = properties.getProperty("user.dir") + File.separatorChar + "testCSHome";
        properties.put("derby.system.home", string);
        System.setProperties(properties);
        boolean bl3 = true;
        String string2 = properties.getProperty("useprocess");
        if (string2 != null && string2.equals("false")) {
            bl3 = false;
        }
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        Class<?> clazz = Class.forName(driver);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (bl) {
            try {
                connection = DriverManager.getConnection(dbURL + ";create=true");
                connection.setAutoCommit(false);
                System.out.println("created " + dbURL + " " + date);
            }
            catch (SQLException sQLException) {
                System.out.println("connect failed for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                System.exit(1);
            }
        } else {
            try {
                connection = DriverManager.getConnection(dbURL);
                connection.setAutoCommit(false);
                System.out.println("connected to " + dbURL + " " + date);
            }
            catch (SQLException sQLException) {
                System.out.println("connect failed for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                System.exit(1);
            }
        }
        date = new Date();
        System.out.println("dbcleanup starting: " + date);
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(" select schemaname from sys.sysschemas  where schemaname <> 'SYS'");
            while (resultSet.next()) {
                vector.addElement(new String(resultSet.getString(1)));
            }
            resultSet.close();
            if (vector.size() > 1) {
                dbIsDirty = true;
            }
        }
        catch (SQLException sQLException) {
            System.out.println("select schemas: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            System.exit(1);
        }
        String string3 = null;
        String string4 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        Vector<String> vector3 = null;
        int n = 0;
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            bl4 = true;
            while (bl4) {
                bl4 = false;
                vector3 = dbcleanup.findTables(connection, statement, 'V', string3);
                if (vector3.size() <= 0) continue;
                System.out.println("schema " + string3);
                bl4 = dbcleanup.dropTables(connection, statement, vector3, "view");
            }
            bl5 = true;
            while (bl5) {
                bl5 = false;
                vector2 = dbcleanup.findTables(connection, statement, 'T', string3);
                if (vector2.size() <= 0) continue;
                System.out.println("schema " + string3);
                bl5 = dbcleanup.dropTables(connection, statement, vector2, "table");
            }
            Vector<String> vector4 = new Vector<String>();
            try {
                resultSet = statement.executeQuery(" select stmtname  from sys.sysstatements t, sys.sysschemas  s  where t.schemaid = s.schemaid  and s.schemaname = '" + string3 + "'");
                n = 0;
                while (resultSet.next()) {
                    dbIsDirty = true;
                    vector4.addElement(new String(resultSet.getString(1)));
                    ++n;
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                System.out.println("select statements: FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                System.exit(1);
            }
            if (n <= true) continue;
            try {
                System.out.println("schema " + string3);
                System.out.println("dropping leftover statements: ");
                enumeration2 = vector4.elements();
                while (enumeration2.hasMoreElements()) {
                    string4 = (String)enumeration2.nextElement();
                    statement.execute("drop statement " + string4);
                    connection.commit();
                    System.out.println("\t" + string4);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("drop statement: FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                System.exit(1);
            }
        }
        if (vector.size() > 1) {
            System.out.println("dropping extra user schemas: ");
            enumeration = null;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                if (string3.equals("APP")) continue;
                if (string3 == null) {
                    System.out.println("null schema in schemalist");
                    continue;
                }
                try {
                    System.out.println("\t" + string3);
                    statement.execute("drop schema \"" + string3 + "\"");
                }
                catch (SQLException sQLException) {
                    System.out.println("drop schema: FAIL -- unexpected exception:");
                    JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                    System.exit(1);
                }
            }
        }
        dbcleanup.dropAliases(connection, 'M');
        dbcleanup.dropAliases(connection, 'C');
        try {
            int n2;
            resultSet = statement.executeQuery("select count (*) from sys.sysdepends");
            if (resultSet.next() && (n2 = resultSet.getInt(1)) > 0) {
                System.out.println("found " + n2 + " leftover dependencies");
            }
        }
        catch (SQLException sQLException) {
            System.out.println("drop schema: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            System.exit(1);
        }
        if (bl3) {
            dbcleanup.doshutdown();
        }
        date = new Date();
        System.out.println("dbcleanup finished: " + date);
    }

    static void doshutdown() {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(dbURL + ";shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("08006")) {
                System.out.println("shutting down " + dbURL);
            }
            System.out.println("shutdown failed for " + dbURL);
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            System.exit(1);
        }
    }

    static boolean dropTables(Connection connection, Statement statement, Vector vector, String string) throws Exception {
        boolean bl = false;
        String string2 = null;
        Object var6_6 = null;
        System.out.println("dropping " + string + "(s)");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            try {
                statement.execute("drop " + string + " " + string2);
                connection.commit();
                System.out.println("\t" + string2);
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("X0Y25")) {
                    bl = true;
                    System.out.println(string2 + " not droped due to dependency, will retry a bit later");
                    continue;
                }
                if (sQLException.getSQLState().equals("X0Y23")) {
                    bl = true;
                    System.out.println(string2 + " not droped due to dependency, will retry a bit later");
                    continue;
                }
                System.out.println("drop table: FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                System.exit(1);
            }
        }
        return bl;
    }

    static Vector<String> findTables(Connection connection, Statement statement, char c, String string) throws Exception {
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            resultSet = statement.executeQuery(" select t.tablename  from sys.systables t, sys.sysschemas  s  where t.schemaid = s.schemaid  and t.tabletype = '" + c + "' and s.schemaname = '" + string + "'");
            while (resultSet.next()) {
                dbIsDirty = true;
                vector.addElement(new String(resultSet.getString(1)));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("select tables: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            System.exit(1);
        }
        return vector;
    }

    static void dropAliases(Connection connection, char c) throws Exception {
        ResultSet resultSet = null;
        Statement statement = null;
        String string = null;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        int n = 0;
        if (c == 'M') {
            string = "method";
        } else if (c == 'C') {
            string = "class";
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select alias, aliastype from sys.sysaliases  where systemalias = false  and aliastype = '" + c + "'");
            n = 0;
            while (resultSet.next()) {
                dbIsDirty = true;
                vector.addElement(new String(resultSet.getString(1)));
                ++n;
            }
            resultSet.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            System.out.println("drop alias: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            System.exit(1);
        }
        if (n > 1) {
            System.out.println("dropping user aliases, type " + string + ": ");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                try {
                    statement.execute("drop " + string + " alias " + string2);
                }
                catch (SQLException sQLException) {
                    System.out.println("drop alias: FAIL -- unexpected exception:");
                    JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                    System.exit(1);
                }
                connection.commit();
                System.out.println("\t" + string2);
            }
        }
    }
}

