/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.utils;

import java.util.ArrayList;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.tasks.Backup;
import org.apache.derbyTesting.system.mailjdbc.tasks.Browse;
import org.apache.derbyTesting.system.mailjdbc.tasks.Purge;
import org.apache.derbyTesting.system.mailjdbc.tasks.Refresh;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;

public class ThreadUtils {
    private static ArrayList<Thread> userThreads = new ArrayList();
    public static ThreadUtils threadutil = new ThreadUtils();

    public static void startThreads() {
        threadutil.run();
    }

    public void run() {
        Thread thread = null;
        try {
            thread = new Refresh("Refresh Thread");
            thread.start();
            MailJdbc.logAct.logMsg(LogFile.INFO + "Started: " + thread.getName());
            userThreads.add(thread);
            thread = new Browse("Browsing Thread");
            thread.start();
            MailJdbc.logAct.logMsg(LogFile.INFO + "Started: " + thread.getName());
            userThreads.add(thread);
            thread = new Purge("Purging Thread");
            int n = 150000;
            Thread.sleep(n);
            thread.start();
            MailJdbc.logAct.logMsg(LogFile.INFO + "Started: " + thread.getName() + " with 150000 sleep time");
            userThreads.add(thread);
            thread = new Backup("Backup Thread");
            thread.start();
            MailJdbc.logAct.logMsg(LogFile.INFO + "Started: " + thread.getName());
            userThreads.add(thread);
            n = (int)(Math.random() * 15000.0);
            Thread.sleep(n);
        }
        catch (Exception exception) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "Exception while starting the threads: " + exception.getMessage());
        }
    }

    public static synchronized boolean isThreadRunning(String string) {
        if (string.equalsIgnoreCase("Refresh Thread")) {
            Refresh refresh = (Refresh)userThreads.get(0);
            return refresh.isRunning();
        }
        return false;
    }

    public static synchronized Thread getThread(String string) {
        if (string.equalsIgnoreCase("Refresh Thread")) {
            return (Refresh)userThreads.get(0);
        }
        if (string.equalsIgnoreCase("Purging Thread")) {
            return (Purge)userThreads.get(2);
        }
        return null;
    }

    public ThreadUtils getInstance() {
        return threadutil;
    }
}

