/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.utils.DbUtil;

public class TesterObject {
    private String thread_id;
    private boolean _deadConnection = false;
    protected Connection connex = null;
    protected DbUtil dbutil;

    public TesterObject(String string) {
        this.thread_id = string;
        this.dbutil = new DbUtil(this.getThread_id());
        NsTest.logger.println("==========> " + this.getThread_id() + " THREAD starting <======");
    }

    public Connection getConnection() {
        Connection connection = null;
        Object object = "";
        try {
            NsTest.logger.println(this.getThread_id() + " is getting a connection to the database...");
            if (NsTest.embeddedMode) {
                object = NsTest.embedDbURL + ";bootPassword=12345678";
            } else if (NsTest.driver_type.equalsIgnoreCase("DerbyClient")) {
                object = NsTest.clientDbURL + ";bootPassword=12345678";
            }
            NsTest.logger.println("-->Thread " + this.getThread_id() + " starting with url " + (String)object + " <--");
            connection = DriverManager.getConnection((String)object, NsTest.prop);
        }
        catch (Exception exception) {
            exception.printStackTrace(NsTest.logger);
            NsTest.logger.println("FAIL: " + this.getThread_id() + " could not get the database connection");
            this.printException("Failed getting database connection using " + (String)object, exception);
        }
        NsTest.addStats(NsTest.CONNECTIONS_MADE, 1);
        NsTest.logger.println("Connection number: " + NsTest.numConnections);
        return connection;
    }

    public Connection getNewConnection() {
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new RuntimeException("Could not get a connection!");
        }
        return connection;
    }

    public void setIsolationLevel(int n) {
        try {
            this.connex.setTransactionIsolation(n);
        }
        catch (Exception exception) {
            NsTest.logger.println("FAIL: " + this.getThread_id() + " could not set isolation level");
            this.printException("setting transaction isolation", exception);
        }
    }

    public void closeConnection() {
        try {
            NsTest.logger.println(this.getThread_id() + " is closing its connection to the database...");
            this.connex.close();
        }
        catch (Exception exception) {
            NsTest.logger.println("FAIL: " + this.getThread_id() + " could not close the database connection");
            this.printException("closing database connection", exception);
        }
    }

    public void doIUDOperation() {
        int n = (int)(Math.random() * 100.0) % 3;
        if (this.connex == null) {
            this.connex = this.getNewConnection();
        }
        switch (n) {
            case 0: {
                try {
                    int n2 = this.dbutil.add_one_row(this.connex, this.getThread_id());
                    if (n2 == 1) {
                        NsTest.addStats(NsTest.INSERT, 1);
                        break;
                    }
                    NsTest.addStats(NsTest.FAILED_INSERT, 1);
                }
                catch (Exception exception) {
                    this.printException("executing add_one_row()", exception);
                    if (!NsTest.deadConnection(exception)) break;
                    this.markDeadConnection();
                }
                break;
            }
            case 1: {
                try {
                    int n3 = this.dbutil.update_one_row(this.connex, this.getThread_id());
                    if (n3 == 1) {
                        NsTest.addStats(NsTest.UPDATE, 1);
                        break;
                    }
                    NsTest.addStats(NsTest.FAILED_UPDATE, 1);
                }
                catch (Exception exception) {
                    this.printException("executing update_one_row", exception);
                    if (!NsTest.deadConnection(exception)) break;
                    this.markDeadConnection();
                }
                break;
            }
            case 2: {
                try {
                    int n4 = this.dbutil.delete_one_row(this.connex, this.getThread_id());
                    if (n4 == 1) {
                        NsTest.addStats(NsTest.DELETE, 1);
                        break;
                    }
                    NsTest.addStats(NsTest.FAILED_DELETE, 1);
                    break;
                }
                catch (Exception exception) {
                    this.printException("executing delete_one_row()", exception);
                    if (!NsTest.deadConnection(exception)) break;
                    this.markDeadConnection();
                }
            }
        }
    }

    public int doSelectOperation(int n) throws SQLException {
        int n2 = 0;
        ResultSet resultSet = null;
        Statement statement = null;
        NsTest.logger.println(this.getThread_id() + " is selecting " + n + " rows");
        try {
            statement = this.connex.createStatement();
            resultSet = statement.executeQuery("select id, t_char, t_date, t_decimal, t_decimal_nn, t_double,  t_float, t_int, t_longint, t_numeric_large, t_real, t_smallint, t_time, t_timestamp, t_varchar, serialkey, sequenceColumn from nstesttab where serialkey <= " + n);
        }
        catch (Exception exception) {
            NsTest.logger.println("FAIL: doSelectOperation() had problems creating/executing query");
            this.printException("FAIL: doSelectOperation() had problems creating/executing query", exception);
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            return n2;
        }
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    int n3 = resultSet.getInt(1);
                    String string = resultSet.getString(2);
                    Date date = resultSet.getDate(3);
                    double d = resultSet.getDouble(4);
                    double d2 = resultSet.getDouble(5);
                    double d3 = resultSet.getDouble(6);
                    float f = resultSet.getFloat(7);
                    int n4 = resultSet.getInt(8);
                    long l = resultSet.getLong(9);
                    double d4 = resultSet.getDouble(10);
                    float f2 = resultSet.getFloat(11);
                    int n5 = resultSet.getInt(12);
                    Time time = resultSet.getTime(13);
                    Timestamp timestamp = resultSet.getTimestamp(14);
                    String string2 = resultSet.getString(15);
                    long l2 = resultSet.getLong(16);
                    long l3 = resultSet.getLong(17);
                    ++n2;
                }
                NsTest.addStats(NsTest.SELECT, 1);
                NsTest.logger.println(this.thread_id + " selected " + n2 + " rows");
            }
            catch (Exception exception) {
                NsTest.logger.println("FAIL: doSelectOperation() had problems working over the ResultSet");
                NsTest.addStats(NsTest.FAILED_SELECT, 1);
                this.printException("processing ResultSet during row data retrieval", exception);
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                NsTest.logger.println("Closed the select statement");
            }
        }
        try {
            if (resultSet != null && statement != null) {
                resultSet.close();
                statement.close();
                NsTest.logger.println("Closed the select statement");
            }
        }
        catch (Exception exception) {
            NsTest.logger.println("FAIL: doSelectOperation() had problems closing the ResultSet");
            this.printException("closing ResultSet of query to get row data", exception);
        }
        return n2;
    }

    public void startTesting() {
    }

    public synchronized void printException(String string, Exception exception) {
        if (NsTest.justCountErrors()) {
            NsTest.addError(exception);
            return;
        }
        if (exception instanceof SQLException) {
            SQLException sQLException = (SQLException)exception;
            if (sQLException.getSQLState().equals("40001")) {
                NsTest.logger.println("TObj --> deadlocked detected");
            }
            if (sQLException.getSQLState().equals("40XL1")) {
                NsTest.logger.println("TObj --> lock timeout exception");
            }
            if (sQLException.getSQLState().equals("23500")) {
                NsTest.logger.println("TObj --> duplicate key violation");
            }
            if (sQLException.getNextException() != null) {
                String string2 = sQLException.getNextException().getSQLState();
                NsTest.logger.println(sQLException.getNextException().getMessage() + " SQLSTATE: " + string2);
            }
        }
        if (exception.getMessage() == null) {
            NsTest.logger.println("TObj -->NULL error message detected");
            NsTest.logger.println("TObj -->Here is the NULL exception - " + exception.toString());
            NsTest.logger.println("TObj -->Stack trace of the NULL exception - ");
            exception.printStackTrace(NsTest.logger);
        }
        NsTest.logger.println("TObj -->At this point - " + string + ", exception thrown was : " + exception.getMessage());
    }

    public String getTimestamp() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return timestamp.toString();
    }

    public String getThread_id() {
        return this.thread_id;
    }

    public void markDeadConnection() {
        this._deadConnection = true;
    }

    public boolean deadConnection() {
        return this._deadConnection;
    }
}

