/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.catalog.SystemProcedures;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DBOAccessTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String JANET = "JANET";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "JANET"};
    private static final String TEST_LOG_FILE = "sys_vti_test_derby.tstlog";
    private static final String ONLY_DBO = "4251D";
    private static final String HIDDEN_COLUMN = "4251E";
    private static final String NULL_BACKUP_DIRECTORY = "XSRS6";
    private static final String FIRST_CREDENTIALS = "4251K";
    private static final String MISSING_OBJECT = "X0X13";
    private static final String MISSING_TABLE = "42X05";
    private static final String NO_SUCH_TABLE = "XIE0M";
    private static final String UNKNOWN_USER = "XK001";
    private static final String SQLJ_INVALID_JAR = "46001";
    private static final String SYSCS_SET_DATABASE_PROPERTY = "SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY";
    private static final String SYSCS_GET_DATABASE_PROPERTY = "SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY";
    private static final String SYSCS_FREEZE_DATABASE = "SYSCS_UTIL.SYSCS_FREEZE_DATABASE";
    private static final String SYSCS_UNFREEZE_DATABASE = "SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE";
    private static final String SYSCS_CHECKPOINT_DATABASE = "SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE";
    private static final String SYSCS_BACKUP_DATABASE = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE";
    private static final String SYSCS_BACKUP_DATABASE_NOWAIT = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT";
    private static final String SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE";
    private static final String SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT = "SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT";
    private static final String SYSCS_DISABLE_LOG_ARCHIVE_MODE = "SYSCS_UTIL.SYSCS_DISABLE_LOG_ARCHIVE_MODE";
    private static final String SYSCS_CHECK_TABLE = "SYSCS_UTIL.SYSCS_CHECK_TABLE";
    private static final String INSTALL_JAR = "SQLJ.INSTALL_JAR";
    private static final String REPLACE_JAR = "SQLJ.REPLACE_JAR";
    private static final String REMOVE_JAR = "SQLJ.REMOVE_JAR";
    private static final String SYSCS_EXPORT_TABLE = "SYSCS_UTIL.SYSCS_EXPORT_TABLE";
    private static final String SYSCS_IMPORT_TABLE = "SYSCS_UTIL.SYSCS_IMPORT_TABLE";
    private static final String SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE = "SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE";
    private static final String SYSCS_IMPORT_DATA = "SYSCS_UTIL.SYSCS_IMPORT_DATA";
    private static final String SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE = "SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE";
    private static final String SYSCS_BULK_INSERT = "SYSCS_UTIL.SYSCS_BULK_INSERT";
    private static final String SYSCS_SET_USER_ACCESS = "SYSCS_UTIL.SYSCS_SET_USER_ACCESS";
    private static final String SYSCS_GET_USER_ACCESS = "SYSCS_UTIL.SYSCS_GET_USER_ACCESS";
    private static final String SYSCS_INVALIDATE_STORED_STATEMENTS = "SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS";
    private static final String SYSCS_EMPTY_STATEMENT_CACHE = "SYSCS_UTIL.SYSCS_EMPTY_STATEMENT_CACHE";
    private static final String SYSCS_SET_XPLAIN_MODE = "SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE";
    private static final String SYSCS_GET_XPLAIN_MODE = "SYSCS_UTIL.SYSCS_GET_XPLAIN_MODE";
    private static final String SYSCS_SET_XPLAIN_SCHEMA = "SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA";
    private static final String SYSCS_GET_XPLAIN_SCHEMA = "SYSCS_UTIL.SYSCS_GET_XPLAIN_SCHEMA";
    private static final String SYSCS_CREATE_USER = "SYSCS_UTIL.SYSCS_CREATE_USER";
    private static final String SYSCS_RESET_PASSWORD = "SYSCS_UTIL.SYSCS_RESET_PASSWORD";
    private static final String SYSCS_DROP_USER = "SYSCS_UTIL.SYSCS_DROP_USER";

    public DBOAccessTest(String string) {
        super(string);
    }

    public boolean authorizationIsOn() {
        return true;
    }

    public static Test suite() {
        String[] stringArray = new String[]{"functionTests/tests/lang/sys_vti_test_derby.tstlog"};
        Object object = TestConfiguration.embeddedSuite(DBOAccessTest.class);
        object = DatabasePropertyTestSetup.builtinAuthentication(object, LEGAL_USERS, "authorizationOnDBOAccessTest");
        object = new SupportFilesSetup((Test)object, stringArray);
        object = TestConfiguration.sqlAuthorizationDecorator(object);
        Object object2 = TestConfiguration.embeddedSuite(NoAuthorization.class);
        object2 = new SupportFilesSetup((Test)object2, stringArray);
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest((Test)object);
        baseTestSuite.addTest((Test)object2);
        return baseTestSuite;
    }

    public void test_5395() throws Exception {
        DBOAccessTest.println("authorizationIsOn() = " + this.authorizationIsOn());
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.minion_5395(connection, true);
        this.minion_5395(connection2, !this.authorizationIsOn());
    }

    private void minion_5395(Connection connection, boolean bl) throws Exception {
        this.vet_5395(connection, bl, "select * from syscs_diag.statement_cache");
        this.vet_5395(connection, bl, "select * from syscs_diag.transaction_table");
        this.vet_5395(connection, bl, "select * from table( syscs_diag.error_log_reader( ) ) s");
        this.vet_5395(connection, bl, "select * from table( syscs_diag.statement_duration() ) s");
        URL uRL = SupportFilesSetup.getReadOnlyURL(TEST_LOG_FILE);
        String string = "'" + uRL.getFile() + "'";
        this.vet_5395(connection, bl, "select * from table( syscs_diag.error_log_reader( " + string + " ) ) s");
        this.vet_5395(connection, bl, "select * from table( syscs_diag.statement_duration( " + string + " ) ) s");
    }

    private void vet_5395(Connection connection, boolean bl, String string) throws Exception {
        if (bl) {
            this.goodStatement(connection, string);
        } else {
            this.expectCompilationError(connection, ONLY_DBO, string);
        }
    }

    public void testSYSUSERS() throws Exception {
        DBOAccessTest.println("testSYSUSERS authorizationIsOn() = " + this.authorizationIsOn());
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.goodStatement(connection, "create view v2 as select username, hashingscheme, lastmodified from sys.sysusers");
        if (this.authorizationIsOn()) {
            this.goodStatement(connection, "grant select on v2 to public");
        }
        this.goodStatement(connection, "create view v3 as select username, hashingscheme, lastmodified from sys.sysusers where password is null");
        if (this.authorizationIsOn()) {
            this.goodStatement(connection, "grant select on v3 to public");
        }
        this.vetDBO_OKProbes(connection, true);
        this.vetDBO_OKProbes(connection2, !this.authorizationIsOn());
        this.vetUnauthorizedProbes(connection, !this.authorizationIsOn(), HIDDEN_COLUMN);
        this.vetUnauthorizedProbes(connection2, !this.authorizationIsOn(), ONLY_DBO);
    }

    private void vetDBO_OKProbes(Connection connection, boolean bl) throws Exception {
        this.vetUserProbes(connection, bl, "select count(*) from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select username, hashingscheme, lastmodified from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select username from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select username, lastmodified from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select username, lastmodified from sys.sysusers where username = 'FRED'", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select count(*) from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select * from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select username, hashingscheme, lastmodified from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(connection, bl, "select username from test_dbo.v2", ONLY_DBO);
    }

    private void vetUnauthorizedProbes(Connection connection, boolean bl, String string) throws Exception {
        this.vetUserProbes(connection, bl, "select * from sys.sysusers", string);
        this.vetUserProbes(connection, bl, "select * from sys.sysusers where username='foo'", string);
        this.vetUserProbes(connection, bl, "select password from sys.sysusers", string);
        this.vetUserProbes(connection, bl, "select username, password from sys.sysusers", string);
        this.vetUserProbes(connection, bl, "select username from sys.sysusers where password = 'foo'", string);
        this.vetUserProbes(connection, bl, "select username, lastmodified from sys.sysusers where password is not null", string);
        this.vetUserProbes(connection, bl, "select * from test_dbo.v3", string);
    }

    private void vetUserProbes(Connection connection, boolean bl, String string, String string2) throws Exception {
        if (bl) {
            this.goodStatement(connection, string);
        } else {
            this.expectCompilationError(connection, string2, string);
        }
    }

    public void test_6616() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(JANET);
        this.goodStatement(connection, "create procedure runSystemRoutine( routineName varchar( 32672 ) )\nlanguage java parameter style java modifies sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.DBOAccessTest.runSystemRoutine'\n");
        if (this.authorizationIsOn()) {
            this.goodStatement(connection, "grant execute on procedure runSystemRoutine to public");
        }
        this.vet6616(connection, connection2, SYSCS_SET_DATABASE_PROPERTY, false);
        this.vet6616(connection, connection2, SYSCS_GET_DATABASE_PROPERTY, true);
        this.vet6616(connection, connection2, SYSCS_FREEZE_DATABASE, false);
        this.vet6616(connection, connection2, SYSCS_UNFREEZE_DATABASE, false);
        this.vet6616(connection, connection2, SYSCS_CHECKPOINT_DATABASE, false);
        this.vet6616(connection, connection2, SYSCS_BACKUP_DATABASE, false);
        this.vet6616(connection, connection2, SYSCS_BACKUP_DATABASE_NOWAIT, false);
        this.vet6616(connection, connection2, SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE, false);
        this.vet6616(connection, connection2, SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT, false);
        this.vet6616(connection, connection2, SYSCS_DISABLE_LOG_ARCHIVE_MODE, false);
        this.vet6616(connection, connection2, SYSCS_CHECK_TABLE, true);
        this.vet6616(connection, connection2, INSTALL_JAR, false);
        this.vet6616(connection, connection2, REPLACE_JAR, false);
        this.vet6616(connection, connection2, REMOVE_JAR, false);
        this.vet6616(connection, connection2, SYSCS_EXPORT_TABLE, false);
        this.vet6616(connection, connection2, SYSCS_IMPORT_TABLE, false);
        this.vet6616(connection, connection2, SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE, false);
        this.vet6616(connection, connection2, SYSCS_IMPORT_DATA, false);
        this.vet6616(connection, connection2, SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE, false);
        this.vet6616(connection, connection2, SYSCS_BULK_INSERT, false);
        this.vet6616(connection, connection2, SYSCS_SET_USER_ACCESS, false);
        this.vet6616(connection, connection2, SYSCS_GET_USER_ACCESS, true);
        this.vet6616(connection, connection2, SYSCS_INVALIDATE_STORED_STATEMENTS, false);
        this.vet6616(connection, connection2, SYSCS_EMPTY_STATEMENT_CACHE, false);
        this.vet6616(connection, connection2, SYSCS_SET_XPLAIN_MODE, false);
        this.vet6616(connection, connection2, SYSCS_GET_XPLAIN_MODE, true);
        this.vet6616(connection, connection2, SYSCS_SET_XPLAIN_SCHEMA, false);
        this.vet6616(connection, connection2, SYSCS_GET_XPLAIN_SCHEMA, true);
        this.vet6616(connection, connection2, SYSCS_CREATE_USER, false);
        this.vet6616(connection, connection2, SYSCS_RESET_PASSWORD, false);
        this.vet6616(connection, connection2, SYSCS_DROP_USER, false);
    }

    private void vet6616(Connection connection, Connection connection2, String string, boolean bl) throws Exception {
        this.vet6616(connection, true, string);
        this.vet6616(connection2, !this.authorizationIsOn(), string);
        if (this.authorizationIsOn()) {
            boolean bl2 = SYSCS_FREEZE_DATABASE.equals(string);
            String string2 = bl ? "function" : "procedure";
            this.goodStatement(connection, "grant execute on " + string2 + " " + string + " to public");
            if (bl2) {
                this.goodStatement(connection, "grant execute on " + string2 + " SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE to public");
            }
            this.vet6616(connection2, true, string);
            this.goodStatement(connection, "revoke execute on " + string2 + " " + string + " from public restrict");
            if (bl2) {
                this.goodStatement(connection, "revoke execute on " + string2 + " SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE from public restrict");
            }
        }
    }

    private void vet6616(Connection connection, boolean bl, String string) throws Exception {
        CallableStatement callableStatement = connection.prepareCall("call test_dbo.runSystemRoutine( ? )");
        callableStatement.setString(1, string);
        try {
            callableStatement.execute();
            if (!bl) {
                DBOAccessTest.fail((String)(string + " should have failed!"));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                DBOAccessTest.fail(string + " should have succeeded", sQLException);
            }
            DBOAccessTest.assertSQLState("42504", sQLException);
        }
    }

    public static void runSystemRoutine(String string) throws Exception {
        if (SYSCS_SET_DATABASE_PROPERTY.equals(string)) {
            SystemProcedures.SYSCS_SET_DATABASE_PROPERTY((String)"foo.bar.wibble", (String)"wibble.bar.foo");
        } else if (SYSCS_GET_DATABASE_PROPERTY.equals(string)) {
            SystemProcedures.SYSCS_GET_DATABASE_PROPERTY((String)"la.dee.dah");
        } else if (SYSCS_FREEZE_DATABASE.equals(string)) {
            SystemProcedures.SYSCS_FREEZE_DATABASE();
            SystemProcedures.SYSCS_UNFREEZE_DATABASE();
        } else if (SYSCS_UNFREEZE_DATABASE.equals(string)) {
            SystemProcedures.SYSCS_UNFREEZE_DATABASE();
        } else if (SYSCS_CHECKPOINT_DATABASE.equals(string)) {
            SystemProcedures.SYSCS_CHECKPOINT_DATABASE();
        } else if (SYSCS_BACKUP_DATABASE.equals(string)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE(null);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, sQLException);
            }
        } else if (SYSCS_BACKUP_DATABASE_NOWAIT.equals(string)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE_NOWAIT(null);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, sQLException);
            }
        } else if (SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE.equals(string)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(null, (short)0);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, sQLException);
            }
        } else if (SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT.equals(string)) {
            try {
                SystemProcedures.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(null, (short)0);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NULL_BACKUP_DIRECTORY, sQLException);
            }
        } else if (SYSCS_DISABLE_LOG_ARCHIVE_MODE.equals(string)) {
            SystemProcedures.SYSCS_DISABLE_LOG_ARCHIVE_MODE((short)0);
        } else if (SYSCS_CHECK_TABLE.equals(string)) {
            SystemProcedures.SYSCS_CHECK_TABLE((String)"SYS", (String)"SYSTABLES");
        } else if (INSTALL_JAR.equals(string)) {
            try {
                SystemProcedures.INSTALL_JAR((String)SupportFilesSetup.getReadOnlyFileName("foo"), (String)"bar", (int)1);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(SQLJ_INVALID_JAR, sQLException);
            }
        } else if (REPLACE_JAR.equals(string)) {
            try {
                SystemProcedures.REPLACE_JAR((String)SupportFilesSetup.getReadOnlyFileName("foo"), (String)"bar");
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(SQLJ_INVALID_JAR, sQLException);
            }
        } else if (REMOVE_JAR.equals(string)) {
            try {
                SystemProcedures.REMOVE_JAR((String)"test_dbo.foo", (int)0);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(MISSING_OBJECT, sQLException);
            }
        } else if (SYSCS_EXPORT_TABLE.equals(string)) {
            try {
                SystemProcedures.SYSCS_EXPORT_TABLE((String)TEST_DBO, (String)"BAR", (String)SupportFilesSetup.getReadWriteFileName("WIBBLE"), null, null, null);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(MISSING_TABLE, sQLException);
            }
        } else if (SYSCS_IMPORT_TABLE.equals(string)) {
            try {
                SystemProcedures.SYSCS_IMPORT_TABLE((String)TEST_DBO, (String)"BAR", (String)SupportFilesSetup.getReadWriteFileName("WIBBLE"), null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, sQLException);
            }
        } else if (SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE.equals(string)) {
            try {
                SystemProcedures.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE((String)TEST_DBO, (String)"BAR", (String)"WIBBLE", null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, sQLException);
            }
        } else if (SYSCS_IMPORT_DATA.equals(string)) {
            try {
                SystemProcedures.SYSCS_IMPORT_DATA((String)TEST_DBO, (String)"BAR", null, (String)"1,3,4", (String)"WIBBLE", null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, sQLException);
            }
        } else if (SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE.equals(string)) {
            try {
                SystemProcedures.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE((String)TEST_DBO, (String)"BAR", null, (String)"1,3,4", (String)"WIBBLE", null, null, null, (short)1);
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(NO_SUCH_TABLE, sQLException);
            }
        } else if (SYSCS_BULK_INSERT.equals(string)) {
            try {
                SystemProcedures.SYSCS_BULK_INSERT((String)TEST_DBO, (String)"BAR", (String)"WIBBLE", (String)"wombat");
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError("42X01", sQLException);
            }
        } else if (SYSCS_SET_USER_ACCESS.equals(string)) {
            SystemProcedures.SYSCS_SET_USER_ACCESS((String)"FOO", (String)"FULLACCESS");
        } else if (SYSCS_GET_USER_ACCESS.equals(string)) {
            SystemProcedures.SYSCS_GET_USER_ACCESS((String)"FOO");
        } else if (SYSCS_INVALIDATE_STORED_STATEMENTS.equals(string)) {
            SystemProcedures.SYSCS_INVALIDATE_STORED_STATEMENTS();
        } else if (SYSCS_EMPTY_STATEMENT_CACHE.equals(string)) {
            SystemProcedures.SYSCS_EMPTY_STATEMENT_CACHE();
        } else if (SYSCS_SET_XPLAIN_MODE.equals(string)) {
            SystemProcedures.SYSCS_SET_XPLAIN_MODE((int)0);
        } else if (SYSCS_GET_XPLAIN_MODE.equals(string)) {
            SystemProcedures.SYSCS_GET_XPLAIN_MODE();
        } else if (SYSCS_SET_XPLAIN_SCHEMA.equals(string)) {
            SystemProcedures.SYSCS_SET_XPLAIN_SCHEMA((String)"");
        } else if (SYSCS_GET_XPLAIN_SCHEMA.equals(string)) {
            SystemProcedures.SYSCS_GET_XPLAIN_SCHEMA();
        } else if (SYSCS_CREATE_USER.equals(string)) {
            try {
                SystemProcedures.SYSCS_CREATE_USER((String)"foo", (String)"bar");
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(FIRST_CREDENTIALS, sQLException);
            }
        } else if (SYSCS_RESET_PASSWORD.equals(string)) {
            try {
                SystemProcedures.SYSCS_RESET_PASSWORD((String)"foo", (String)"bar");
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(UNKNOWN_USER, sQLException);
            }
        } else if (SYSCS_DROP_USER.equals(string)) {
            try {
                SystemProcedures.SYSCS_DROP_USER((String)"foo");
                DBOAccessTest.fail();
            }
            catch (SQLException sQLException) {
                DBOAccessTest.vetError(UNKNOWN_USER, sQLException);
            }
        } else {
            throw new Exception("Unknown routine name: " + string);
        }
    }

    private static void vetError(String string, SQLException sQLException) throws SQLException {
        if (!string.equals(sQLException.getSQLState())) {
            throw sQLException;
        }
        DBOAccessTest.println("Caught expected error: " + string);
    }

    public static final class NoAuthorization
    extends DBOAccessTest {
        public NoAuthorization(String string) {
            super(string);
        }

        @Override
        public boolean authorizationIsOn() {
            return false;
        }
    }
}

