/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.Term;
import org.apache.lucene.util.RamUsageEstimator;

final class NumericUpdate {
    private static final int RAW_SIZE_IN_BYTES = 9 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 32 + 8;
    static final Long MISSING = new Long(0L);
    Term term;
    String field;
    Long value;
    int docIDUpto = -1;

    NumericUpdate(Term term, String field, Long value) {
        this.term = term;
        this.field = field;
        this.value = value == null ? MISSING : value;
    }

    int sizeInBytes() {
        int sizeInBytes = RAW_SIZE_IN_BYTES;
        sizeInBytes += this.term.field.length() * 2;
        sizeInBytes += this.term.bytes.bytes.length;
        return sizeInBytes += this.field.length() * 2;
    }

    public String toString() {
        return "term=" + this.term + ",field=" + this.field + ",value=" + this.value;
    }
}

