/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;

public final class DeliveryMethodSyntaxChecker
extends SyntaxChecker {
    private static final String[] PDMS = new String[]{"any", "mhs", "physical", "telex", "teletex", "g3fax", "g4fax", "ia5", "videotex", "telephone"};
    private static final Set<String> DELIVERY_METHODS = new HashSet<String>();
    public static final DeliveryMethodSyntaxChecker INSTANCE;

    private DeliveryMethodSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    private int isPdm(String strValue, int start, Set<String> pdms) {
        int pos = start;
        while (Chars.isAlphaDigit((String)strValue, (int)pos)) {
            ++pos;
        }
        if (pos == start) {
            return -1;
        }
        String pdm = strValue.substring(start, pos);
        if (!DELIVERY_METHODS.contains(pdm)) {
            return -1;
        }
        if (pdms.contains(pdm)) {
            return -1;
        }
        pdms.add(pdm);
        return pos;
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        int length = strValue.length();
        int pos = 0;
        HashSet<String> pmds = new HashSet<String>();
        if ((pos = this.isPdm(strValue, pos, pmds)) == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        while (pos < length) {
            while (Strings.isCharASCII((String)strValue, (int)pos, (char)' ')) {
                ++pos;
            }
            if (!Strings.isCharASCII((String)strValue, (int)pos, (char)'$')) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
                }
                return false;
            }
            ++pos;
            while (Strings.isCharASCII((String)strValue, (int)pos, (char)' ')) {
                ++pos;
            }
            if ((pos = this.isPdm(strValue, pos, pmds)) != -1) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
        }
        return true;
    }

    static {
        for (String country : PDMS) {
            DELIVERY_METHODS.add(country);
        }
        INSTANCE = new DeliveryMethodSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.14");
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DeliveryMethodSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.14");
        }

        @Override
        public DeliveryMethodSyntaxChecker build() {
            return new DeliveryMethodSyntaxChecker(this.oid);
        }
    }
}

