/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.Decorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class LdapResultDecorator
implements LdapResult,
Decorator<LdapResult> {
    private final LdapResult decoratedLdapResult;
    private byte[] errorMessageBytes;
    private byte[] matchedDnBytes;
    private LdapApiService codec;
    private static final byte[] DEFAULT_SUCCESS = new byte[]{10, 1, 0, 4, 0, 4, 0};

    public LdapResultDecorator(LdapApiService codec, LdapResult decoratedLdapResult) {
        this.decoratedLdapResult = decoratedLdapResult;
        this.codec = codec;
    }

    public ResultCodeEnum getResultCode() {
        return this.decoratedLdapResult.getResultCode();
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.decoratedLdapResult.setResultCode(resultCode);
    }

    public Dn getMatchedDn() {
        return this.decoratedLdapResult.getMatchedDn();
    }

    public void setMatchedDn(Dn dn) {
        this.decoratedLdapResult.setMatchedDn(dn);
    }

    public String getDiagnosticMessage() {
        return this.decoratedLdapResult.getDiagnosticMessage();
    }

    public void setDiagnosticMessage(String diagnosticMessage) {
        this.decoratedLdapResult.setDiagnosticMessage(diagnosticMessage);
    }

    public boolean isReferral() {
        return this.decoratedLdapResult.isReferral();
    }

    public Referral getReferral() {
        return this.decoratedLdapResult.getReferral();
    }

    public void setReferral(Referral referral) {
        this.decoratedLdapResult.setReferral(referral);
    }

    public String toString() {
        return this.decoratedLdapResult.toString();
    }

    @Override
    public int computeLength() {
        if (this.decoratedLdapResult.isDefaultSuccess()) {
            return DEFAULT_SUCCESS.length;
        }
        int ldapResultLength = 2 + BerValue.getNbBytes((int)this.getResultCode().getValue());
        if (this.getMatchedDn() == null) {
            ldapResultLength += 2;
        } else {
            this.matchedDnBytes = Strings.getBytesUtf8Ascii((String)Strings.trimLeft((String)this.getMatchedDn().getName()));
            ldapResultLength += 1 + TLV.getNbBytes((int)this.matchedDnBytes.length) + this.matchedDnBytes.length;
        }
        this.errorMessageBytes = Strings.getBytesUtf8Ascii((String)this.getDiagnosticMessage());
        ldapResultLength += 1 + TLV.getNbBytes((int)this.errorMessageBytes.length) + this.errorMessageBytes.length;
        int referralLength = LdapEncoder.computeReferralLength(this.getReferral());
        if (referralLength != 0) {
            ldapResultLength += 1 + TLV.getNbBytes((int)referralLength) + referralLength;
        }
        return ldapResultLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        if (this.decoratedLdapResult.isDefaultSuccess()) {
            buffer.put(DEFAULT_SUCCESS);
            return buffer;
        }
        try {
            BerValue.encodeEnumerated((ByteBuffer)buffer, (int)this.getResultCode().getValue());
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        BerValue.encode((ByteBuffer)buffer, (byte[])this.matchedDnBytes);
        BerValue.encode((ByteBuffer)buffer, (byte[])this.errorMessageBytes);
        Referral referral = this.getReferral();
        if (referral != null) {
            LdapEncoder.encodeReferral(buffer, referral);
        }
        return buffer;
    }

    @Override
    public LdapResult getDecorated() {
        return this.decoratedLdapResult;
    }

    @Override
    public LdapApiService getCodecService() {
        return this.codec;
    }

    public boolean isDefaultSuccess() {
        return this.decoratedLdapResult.isDefaultSuccess();
    }
}

