/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class ObjectClassTypeSyntaxChecker
extends SyntaxChecker {
    public static final ObjectClassTypeSyntaxChecker INSTANCE = new ObjectClassTypeSyntaxChecker("1.3.6.1.4.1.18060.0.4.0.0.1");

    private ObjectClassTypeSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() < 8 || strValue.length() > 10) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        switch (strValue) {
            case "AUXILIARY": 
            case "ABSTRACT": 
            case "STRUCTURAL": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{value}));
                }
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
        }
        return false;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<ObjectClassTypeSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.0.0.1");
        }

        @Override
        public ObjectClassTypeSyntaxChecker build() {
            return new ObjectClassTypeSyntaxChecker(this.oid);
        }
    }
}

