/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import java.util.Iterator;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.ResponseFactory;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.util.CollectionUtils;

public final class SearchResultEntryFactory
extends ResponseFactory {
    public static final SearchResultEntryFactory INSTANCE = new SearchResultEntryFactory();

    private SearchResultEntryFactory() {
    }

    private void encodeValues(Asn1Buffer buffer, Iterator<Value> values) {
        values = CollectionUtils.reverse(values);
        while (values.hasNext()) {
            Value value = values.next();
            if (value.isHumanReadable()) {
                BerValue.encodeOctetString(buffer, value.getString());
                continue;
            }
            BerValue.encodeOctetString(buffer, value.getBytes());
        }
    }

    private void encodeAttributes(Asn1Buffer buffer, Iterator<Attribute> attributes) {
        attributes = CollectionUtils.reverse(attributes);
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            int start = buffer.getPos();
            if (attribute.size() != 0) {
                this.encodeValues(buffer, attribute.iterator());
            }
            BerValue.encodeSet(buffer, start);
            BerValue.encodeOctetString(buffer, attribute.getUpId());
            BerValue.encodeSequence(buffer, start);
        }
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        SearchResultEntry searchResultEntry = (SearchResultEntry)message;
        Entry entry = searchResultEntry.getEntry();
        if (entry != null && entry.size() != 0) {
            this.encodeAttributes(buffer, entry.iterator());
        }
        BerValue.encodeSequence(buffer, start);
        BerValue.encodeOctetString(buffer, searchResultEntry.getObjectName().getName());
        BerValue.encodeSequence(buffer, (byte)100, start);
    }
}

