/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectResponseContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectStatesEnum;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GracefulDisconnectResponseGrammar
extends AbstractGrammar<GracefulDisconnectResponseContainer> {
    static final Logger LOG = LoggerFactory.getLogger(GracefulDisconnectResponseGrammar.class);
    private static GracefulDisconnectResponseGrammar instance = new GracefulDisconnectResponseGrammar();
    private GrammarAction<GracefulDisconnectResponseContainer> storeDelay = new GrammarAction<GracefulDisconnectResponseContainer>("Set Graceful Disconnect Delay"){

        @Override
        public void action(GracefulDisconnectResponseContainer container) throws DecoderException {
            BerValue value = container.getCurrentTLV().getValue();
            try {
                int delay = IntegerDecoder.parse(value, 0, 86400);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08204_DELAY, delay));
                }
                container.getGracefulDisconnectResponse().setDelay(delay);
                container.setGrammarEndAllowed(true);
            }
            catch (IntegerDecoderException ide) {
                String msg = I18n.err(I18n.ERR_08205_CANNOT_DECODE_DELAY, Strings.dumpBytes(value.getData()));
                LOG.error(msg);
                throw new DecoderException(msg, ide);
            }
        }
    };
    private GrammarAction<GracefulDisconnectResponseContainer> storeReferral = new GrammarAction<GracefulDisconnectResponseContainer>("Stores a referral"){

        @Override
        public void action(GracefulDisconnectResponseContainer container) throws DecoderException {
            BerValue value = container.getCurrentTLV().getValue();
            try {
                if (Strings.isEmpty(value.getData())) {
                    String msg = I18n.err(I18n.ERR_08224_NULL_URL_DECODING_FAILURE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                String url = Strings.utf8ToString(value.getData());
                LdapUrl ldapUrl = new LdapUrl(url);
                container.getGracefulDisconnectResponse().addReplicatedContexts(url);
                container.setGrammarEndAllowed(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08214_STORES_A_REFERRAL, ldapUrl));
                }
            }
            catch (LdapURLEncodingException luee) {
                String msg = I18n.err(I18n.ERR_08225_URL_DECODING_FAILURE, Strings.dumpBytes(value.getData()));
                LOG.error(msg);
                throw new DecoderException(msg, luee);
            }
        }
    };
    private GrammarAction<GracefulDisconnectResponseContainer> storeTimeOffline = new GrammarAction<GracefulDisconnectResponseContainer>("Set Graceful Disconnect time offline"){

        @Override
        public void action(GracefulDisconnectResponseContainer container) throws DecoderException {
            BerValue value = container.getCurrentTLV().getValue();
            try {
                int timeOffline = IntegerDecoder.parse(value, 0, 720);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08216_TIME_OFFLINE, timeOffline));
                }
                container.getGracefulDisconnectResponse().setTimeOffline(timeOffline);
                container.setGrammarEndAllowed(true);
            }
            catch (IntegerDecoderException ide) {
                String msg = I18n.err(I18n.ERR_08206_TIME_OFFLINE_DECODING_FAILED, Strings.dumpBytes(value.getData()));
                LOG.error(msg);
                throw new DecoderException(msg, ide);
            }
        }
    };

    private GracefulDisconnectResponseGrammar() {
        this.setName(GracefulDisconnectResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[GracefulDisconnectStatesEnum.LAST_GRACEFUL_DISCONNECT_STATE.ordinal()][256];
        this.transitions[GracefulDisconnectStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<GracefulDisconnectResponseContainer>(GracefulDisconnectStatesEnum.START_STATE, GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<GracefulDisconnectResponseContainer>("Init Graceful Disconnect"){

            @Override
            public void action(GracefulDisconnectResponseContainer container) {
                if (container.getCurrentTLV().getLength() == 0) {
                    container.setGrammarEndAllowed(true);
                }
            }
        });
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<GracefulDisconnectResponseContainer>(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, UniversalTag.INTEGER.getValue(), this.storeTimeOffline);
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition<GracefulDisconnectResponseContainer>(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, GracefulDisconnectStatesEnum.DELAY_STATE, 128, this.storeDelay);
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE.ordinal()][128] = new GrammarTransition<GracefulDisconnectResponseContainer>(GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, GracefulDisconnectStatesEnum.DELAY_STATE, 128, this.storeDelay);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[GracefulDisconnectStatesEnum.DELAY_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(GracefulDisconnectStatesEnum.DELAY_STATE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<GracefulDisconnectResponseContainer>(GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, GracefulDisconnectStatesEnum.REFERRAL_STATE, UniversalTag.OCTET_STRING.getValue(), this.storeReferral);
        this.transitions[GracefulDisconnectStatesEnum.REFERRAL_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<GracefulDisconnectResponseContainer>(GracefulDisconnectStatesEnum.REFERRAL_STATE, GracefulDisconnectStatesEnum.REFERRAL_STATE, UniversalTag.OCTET_STRING.getValue(), this.storeReferral);
    }

    public static GracefulDisconnectResponseGrammar getInstance() {
        return instance;
    }
}

