/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.URIResolver;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.Resolver;
import org.xml.sax.EntityResolver;

public class OdfPackageDocument
implements Closeable {
    private static final String TWO_DOTS = "..";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String EMPTY_STRING = "";
    protected static final String ROOT_DOCUMENT_PATH = "";
    private Resolver mResolver;
    protected OdfPackage mPackage;
    protected String mDocumentPathInPackage;
    protected String mDocumentMediaType;

    protected OdfPackageDocument(OdfPackage pkg, String internalPath, String mediaTypeString) {
        if (pkg == null) {
            throw new IllegalArgumentException("No Package provided for new document!");
        }
        this.mPackage = pkg;
        this.mDocumentPathInPackage = internalPath;
        this.setMediaTypeString(mediaTypeString);
        pkg.cacheDocument(this, internalPath);
    }

    public static OdfPackageDocument loadDocument(String documentPath) throws Exception {
        OdfPackage pkg = OdfPackage.loadPackage(documentPath);
        return pkg.loadDocument("");
    }

    public OdfPackageDocument loadSubDocument(String documentPath) {
        String internalPath = this.getDocumentPath() + documentPath;
        internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
        return this.mPackage.loadDocument(internalPath);
    }

    public String getMediaTypeString() {
        return this.mDocumentMediaType;
    }

    protected final void setMediaTypeString(String mediaTypeString) {
        this.mDocumentMediaType = mediaTypeString;
        if (this.isRootDocument()) {
            this.mPackage.setMediaTypeString(mediaTypeString);
        }
    }

    void setPackage(OdfPackage pkg) {
        this.mPackage = pkg;
    }

    public OdfPackage getPackage() {
        return this.mPackage;
    }

    String setDocumentPath(String path) {
        this.mDocumentPathInPackage = OdfPackageDocument.normalizeDocumentPath(path);
        return this.mDocumentPathInPackage;
    }

    public String getDocumentPath() {
        return this.mDocumentPathInPackage;
    }

    public void removeDocument(String internDocumentPath) {
        this.mPackage.removeDocument(this.mDocumentPathInPackage + internDocumentPath);
    }

    public boolean isRootDocument() {
        return this.getDocumentPath().equals("");
    }

    protected static boolean isExternalReference(String ref) {
        boolean isExternalReference = false;
        if (ref.startsWith(TWO_DOTS) || ref.startsWith(SLASH) && !ref.equals(SLASH) || ref.contains(COLON)) {
            isExternalReference = true;
        }
        return isExternalReference;
    }

    protected static String normalizeDocumentPath(String documentPath) {
        String dirPath = OdfPackage.normalizeDirectoryPath(documentPath);
        if (dirPath.startsWith(SLASH) && !dirPath.equals(SLASH)) {
            dirPath = dirPath.substring(1);
        }
        return dirPath;
    }

    public void save(String documentPath) throws Exception {
        File f = new File(documentPath);
        this.save(f);
    }

    public void save(File file) throws Exception {
        this.mPackage.save(file);
    }

    protected void flushDoms() {
        this.mPackage.flushDoms(this);
    }

    public void insertDocument(OdfPackageDocument newDocument, String documentPath) {
        newDocument.flushDoms();
        this.mPackage.insertDocument(newDocument, this.mDocumentPathInPackage + documentPath);
    }

    public OdfFileDom getFileDom(String internalPath) throws Exception {
        String normalizeDocumentPath = this.getDocumentPath();
        if (!this.isRootDocument()) {
            normalizeDocumentPath = OdfPackageDocument.normalizeDocumentPath(normalizeDocumentPath);
        }
        return OdfFileDom.newFileDom(this, normalizeDocumentPath + internalPath);
    }

    EntityResolver getEntityResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver(this.mPackage);
        }
        return this.mResolver;
    }

    URIResolver getURIResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver(this.mPackage);
        }
        return this.mResolver;
    }

    public void close() {
        this.mPackage.close();
        this.mPackage = null;
    }

    protected static class Resource {
        private String name;

        public Resource(String name) {
            this.name = name;
        }

        public InputStream createInputStream() {
            InputStream in = OdfPackageDocument.class.getResourceAsStream(this.name);
            if (in == null) {
                Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, "Could not find resource: {0}", this.name);
            }
            return in;
        }
    }
}

