/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.dubbo.apidocs.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Dimension request parameter.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.PARAMETER})
@Documented
@Inherited
public @interface RequestParam {

    /**
     * param name
     */
    String value();

    /**
     * required
     */
    boolean required() default false;

    /**
     * description(HTML tags available)
     */
    String description() default "";

    /**
     * example(HTML tags available)
     */
    String example() default "";

    /**
     * default value
     */
    String defaultValue() default "";

    /**
     * Allowed values. After setting this property, a drop-down list will be generated for the parameter <br />
     * Note: a drop-down selection box will be generated after using this property<br />
     * 1. Parameters of boolean type do not need to be set with this property. A drop-down list of true / false will be generated by default<br />
     * 2. Parameters of enumeration type will automatically generate a drop-down list. If you do not want to open all enumeration values, you can set this property separately.
     */
    String[] allowableValues() default {};

}
