/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.felix.connect.Revision;

class URLRevision
implements Revision {
    private final URL m_url;
    private final long m_lastModified;

    public URLRevision(URL url, long lastModified) {
        this.m_url = url;
        this.m_lastModified = lastModified > 0L ? lastModified : System.currentTimeMillis();
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    @Override
    public Enumeration<String> getEntries() {
        return Collections.emptyEnumeration();
    }

    @Override
    public URL getEntry(String entryName) {
        try {
            return new URL(this.m_url, entryName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

